/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.polarsexplorationadditions.procedures;

import net.mcreator.polarsexplorationadditions.entity.SoulBulletEntity;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SoulChargeRightclickedProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        Entity _shootFrom;
        Level projectileLevel;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity _entity = (LivingEntity)entity;
            _entity.swing(InteractionHand.MAIN_HAND, true);
        }
        if (!(projectileLevel = (_shootFrom = entity).level()).isClientSide()) {
            AbstractArrow _entityToSpawn = SoulChargeRightclickedProcedure.initArrowProjectile(new SoulBulletEntity((EntityType<? extends SoulBulletEntity>)((EntityType)PolarsExplorationAdditionsModEntities.SOUL_BULLET.get()), 0.0, 0.0, 0.0, projectileLevel, SoulChargeRightclickedProcedure.createArrowWeaponItemStack(projectileLevel, 1, (byte)0)), null, 5.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
            _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
            _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 2.0f, 0.1f);
            projectileLevel.addFreshEntity((Entity)_entityToSpawn);
        }
        if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.isClientSide()) {
                _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"polars_exploration_additions:soul")), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"polars_exploration_additions:soul")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
            }
        }
        if (SoulChargeRightclickedProcedure.getEntityGameType(entity) != GameType.CREATIVE) {
            itemstack.shrink(1);
        }
        if (entity instanceof Player) {
            Player _player = (Player)entity;
            _player.getCooldowns().addCooldown(itemstack, 10);
        }
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

