/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.polarsexplorationadditions.procedures;

import javax.annotation.Nullable;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModBlocks;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModEntities;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class TuffFrameOnBlockRightClickedProcedure {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        TuffFrameOnBlockRightClickedProcedure.execute((Event)event, (LevelAccessor)event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        TuffFrameOnBlockRightClickedProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        ItemStack itemStack;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity _livEnt = (LivingEntity)entity;
            itemStack = _livEnt.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        if (itemStack.getItem() == Items.ECHO_SHARD && world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() == PolarsExplorationAdditionsModBlocks.TUFF_FRAME.get()) {
            Entity entityToSpawn;
            Level _level;
            if (entity instanceof LivingEntity) {
                LivingEntity _entity = (LivingEntity)entity;
                _entity.swing(InteractionHand.MAIN_HAND, true);
            }
            if (TuffFrameOnBlockRightClickedProcedure.getEntityGameType(entity) != GameType.CREATIVE) {
                ItemStack itemStack2;
                if (entity instanceof LivingEntity) {
                    LivingEntity _livEnt = (LivingEntity)entity;
                    itemStack2 = _livEnt.getMainHandItem();
                } else {
                    itemStack2 = ItemStack.EMPTY;
                }
                itemStack2.shrink(1);
            }
            BlockPos _bp = BlockPos.containing((double)x, (double)y, (double)z);
            BlockState _bs = ((Block)PolarsExplorationAdditionsModBlocks.TUFF_FRAME_FILLED.get()).defaultBlockState();
            BlockState _bso = world.getBlockState(_bp);
            for (Property _propertyOld : _bso.getProperties()) {
                Property _propertyNew = _bs.getBlock().getStateDefinition().getProperty(_propertyOld.getName());
                if (_propertyNew == null || _bs.getValue(_propertyNew) == null) continue;
                try {
                    _bs = (BlockState)_bs.setValue(_propertyNew, _bso.getValue(_propertyOld));
                }
                catch (Exception exception) {}
            }
            world.setBlock(_bp, _bs, 3);
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.breeze.shoot")), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.breeze.shoot")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"item.trident.return")), SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"item.trident.return")), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"polars_exploration_additions:soul2")), SoundSource.BLOCKS, 2.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"polars_exploration_additions:soul2")), SoundSource.BLOCKS, 2.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)((SimpleParticleType)PolarsExplorationAdditionsModParticleTypes.SOUL_FIRE.get()), x + 0.5, y + 0.5, z - 0.3, 4, 0.2, 0.2, 0.2, 0.0);
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, x + 0.5, y + 0.5, z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (Direction.NORTH == TuffFrameOnBlockRightClickedProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z))) {
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    entityToSpawn = ((EntityType)PolarsExplorationAdditionsModEntities.POLTERGEIST.get()).spawn((ServerLevel)_level, BlockPos.containing((double)(x + 0.5), (double)(y + 2.0), (double)(z + 2.5)), EntitySpawnReason.MOB_SUMMONED);
                    if (entityToSpawn != null) {
                        entityToSpawn.setDeltaMovement(0.0, 0.3, 0.0);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)PolarsExplorationAdditionsModParticleTypes.SOUL_EXPLOSION.get()), x + 0.5, y + 2.0, z + 2.5, 7, 1.0, 1.0, 1.0, 0.0);
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.FLASH, x + 0.5, y + 2.0, z + 2.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (Direction.SOUTH == TuffFrameOnBlockRightClickedProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z))) {
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    entityToSpawn = ((EntityType)PolarsExplorationAdditionsModEntities.POLTERGEIST.get()).spawn((ServerLevel)_level, BlockPos.containing((double)(x + 0.5), (double)(y + 2.0), (double)(z + -1.5)), EntitySpawnReason.MOB_SUMMONED);
                    if (entityToSpawn != null) {
                        entityToSpawn.setDeltaMovement(0.0, 0.3, 0.0);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)PolarsExplorationAdditionsModParticleTypes.SOUL_EXPLOSION.get()), x + 0.5, y + 2.0, z + -1.5, 7, 1.0, 1.0, 1.0, 0.0);
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.FLASH, x + 0.5, y + 2.0, z + -1.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (Direction.WEST == TuffFrameOnBlockRightClickedProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z))) {
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    entityToSpawn = ((EntityType)PolarsExplorationAdditionsModEntities.POLTERGEIST.get()).spawn((ServerLevel)_level, BlockPos.containing((double)(x + 2.5), (double)(y + 2.0), (double)(z + 0.5)), EntitySpawnReason.MOB_SUMMONED);
                    if (entityToSpawn != null) {
                        entityToSpawn.setDeltaMovement(0.0, 0.3, 0.0);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)PolarsExplorationAdditionsModParticleTypes.SOUL_EXPLOSION.get()), x + 2.5, y + 2.0, z + 0.5, 7, 1.0, 1.0, 1.0, 0.0);
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.FLASH, x + 2.5, y + 2.0, z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (Direction.EAST == TuffFrameOnBlockRightClickedProcedure.getBlockDirection(world, BlockPos.containing((double)x, (double)y, (double)z))) {
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    entityToSpawn = ((EntityType)PolarsExplorationAdditionsModEntities.POLTERGEIST.get()).spawn((ServerLevel)_level, BlockPos.containing((double)(x + -1.5), (double)(y + 2.0), (double)(z + 0.5)), EntitySpawnReason.MOB_SUMMONED);
                    if (entityToSpawn != null) {
                        entityToSpawn.setDeltaMovement(0.0, 0.3, 0.0);
                    }
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)((SimpleParticleType)PolarsExplorationAdditionsModParticleTypes.SOUL_EXPLOSION.get()), x + -1.5, y + 2.0, z + 0.5, 7, 1.0, 1.0, 1.0, 0.0);
                }
                if (world instanceof ServerLevel) {
                    _level = (ServerLevel)world;
                    _level.sendParticles((ParticleOptions)ParticleTypes.FLASH, x + -1.5, y + 2.0, z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }

    private static Direction getBlockDirection(LevelAccessor world, BlockPos pos) {
        Comparable comparable;
        BlockState blockState = world.getBlockState(pos);
        Property property = blockState.getBlock().getStateDefinition().getProperty("facing");
        if (property != null && (comparable = blockState.getValue(property)) instanceof Direction) {
            Direction direction = (Direction)comparable;
            return direction;
        }
        if (blockState.hasProperty((Property)BlockStateProperties.AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            return Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        }
        return Direction.NORTH;
    }
}

