/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.polarsexplorationadditions.block;

import java.util.List;
import net.mcreator.polarsexplorationadditions.procedures.ThrusterBlockIsPlacedByProcedure;
import net.mcreator.polarsexplorationadditions.procedures.ThrusterEntityWalksOnTheBlockProcedure;
import net.mcreator.polarsexplorationadditions.procedures.ThrusterUpdateTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ThrusterBlock
extends Block {
    public ThrusterBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.NETHERITE_BLOCK).instabreak().lightLevel(s -> 8).noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.polars_exploration_additions.thruster.description_0"));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)ThrusterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)7.0, (double)7.0), (VoxelShape[])new VoxelShape[]{ThrusterBlock.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)7.0), ThrusterBlock.box((double)0.0, (double)0.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0), ThrusterBlock.box((double)9.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0, (double)16.0), ThrusterBlock.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)1.0, (double)9.0), ThrusterBlock.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)1.0, (double)7.0), ThrusterBlock.box((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)1.0, (double)16.0)});
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 5);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        ThrusterUpdateTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 5);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        ThrusterEntityWalksOnTheBlockProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), entity);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        ThrusterBlockIsPlacedByProcedure.execute((Entity)entity);
    }
}

