/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.polarsexplorationadditions.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mcreator.polarsexplorationadditions.init.PolarsExplorationAdditionsModScreens;
import net.mcreator.polarsexplorationadditions.world.inventory.TeleporterguiMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class TeleporterguiScreen
extends AbstractContainerScreen<TeleporterguiMenu>
implements PolarsExplorationAdditionsModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox xcoord;
    private EditBox ycoord;
    private EditBox zcoord;
    private Checkbox check;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"polars_exploration_additions:textures/screens/teleportergui.png");

    public TeleporterguiScreen(TeleporterguiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("xcoord")) {
                this.xcoord.setValue(stringState);
            } else if (name.equals("ycoord")) {
                this.ycoord.setValue(stringState);
            } else if (name.equals("zcoord")) {
                this.zcoord.setValue(stringState);
            }
        }
        if (elementType == 1 && elementState instanceof Boolean) {
            Boolean logicState = (Boolean)elementState;
            if (name.equals("check") && this.check.selected() != logicState.booleanValue()) {
                this.check.onPress();
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.xcoord.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.ycoord.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.zcoord.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.xcoord.isFocused()) {
            return this.xcoord.keyPressed(key, b, c);
        }
        if (this.ycoord.isFocused()) {
            return this.ycoord.keyPressed(key, b, c);
        }
        if (this.zcoord.isFocused()) {
            return this.zcoord.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String xcoordValue = this.xcoord.getValue();
        String ycoordValue = this.ycoord.getValue();
        String zcoordValue = this.zcoord.getValue();
        super.resize(minecraft, width, height);
        this.xcoord.setValue(xcoordValue);
        this.ycoord.setValue(ycoordValue);
        this.zcoord.setValue(zcoordValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.label_teleporter"), 8, 5, -12829636, false);
    }

    public void init() {
        super.init();
        this.xcoord = new EditBox(this.font, this.leftPos + 10, this.topPos + 18, 118, 18, (Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.xcoord"));
        this.xcoord.setMaxLength(8192);
        this.xcoord.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleporterguiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "xcoord", content, false);
            }
        });
        this.xcoord.setHint((Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.xcoord"));
        this.addWidget((GuiEventListener)this.xcoord);
        this.ycoord = new EditBox(this.font, this.leftPos + 10, this.topPos + 39, 118, 18, (Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.ycoord"));
        this.ycoord.setMaxLength(8192);
        this.ycoord.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleporterguiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "ycoord", content, false);
            }
        });
        this.ycoord.setHint((Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.ycoord"));
        this.addWidget((GuiEventListener)this.ycoord);
        this.zcoord = new EditBox(this.font, this.leftPos + 10, this.topPos + 60, 118, 18, (Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.zcoord"));
        this.zcoord.setMaxLength(8192);
        this.zcoord.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((TeleporterguiMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "zcoord", content, false);
            }
        });
        this.zcoord.setHint((Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.zcoord"));
        this.addWidget((GuiEventListener)this.zcoord);
        this.check = Checkbox.builder((Component)Component.translatable((String)"gui.polars_exploration_additions.teleportergui.check"), (Font)this.font).pos(this.leftPos + 136, this.topPos + 17).onValueChange((checkbox, value) -> {
            if (!this.menuStateUpdateActive) {
                ((TeleporterguiMenu)this.menu).sendMenuStateUpdate(this.entity, 1, "check", value, false);
            }
        }).build();
        this.addRenderableWidget((GuiEventListener)this.check);
    }
}

