/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.polarsexplorationadditions.init;

import net.mcreator.polarsexplorationadditions.potion.FreezingMobEffect;
import net.mcreator.polarsexplorationadditions.potion.GrowthMobEffect;
import net.mcreator.polarsexplorationadditions.potion.ImmunityMobEffect;
import net.mcreator.polarsexplorationadditions.potion.RavagingMobEffect;
import net.mcreator.polarsexplorationadditions.potion.SoulOmenMobEffect;
import net.mcreator.polarsexplorationadditions.procedures.RavagingEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class PolarsExplorationAdditionsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"polars_exploration_additions");
    public static final DeferredHolder<MobEffect, MobEffect> FREEZING = REGISTRY.register("freezing", () -> new FreezingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RAVAGING = REGISTRY.register("ravaging", () -> new RavagingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IMMUNITY = REGISTRY.register("immunity", () -> new ImmunityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SOUL_OMEN = REGISTRY.register("soul_omen", () -> new SoulOmenMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GROWTH = REGISTRY.register("growth", () -> new GrowthMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            PolarsExplorationAdditionsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            PolarsExplorationAdditionsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(RAVAGING)) {
            RavagingEffectExpiresProcedure.execute(entity);
        }
    }
}

