/*
 * Decompiled with CFR 0.152.
 */
package com.mcreator.polarsexplorationadditions;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ItemVoidFixerProcedure {
    private static final double SLOW_FALL_SPEED = -0.01;
    private static final float SOUND_PROBABILITY = 0.1f;
    private static final Random RANDOM = new Random();
    private static final TagKey<Item> ENDERITE_ITEMS_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("polars_exploration_additions", "enderite_items"));

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Level world : event.getServer().m_129785_()) {
                double voidThreshold = world.m_46472_() == Level.f_46428_ ? -63.0 : 1.0;
                double platformY = voidThreshold;
                double teleportY = platformY + 1.0;
                AABB searchArea = new AABB(BlockPos.f_121853_).m_82400_(500.0);
                world.m_6443_(ItemEntity.class, searchArea, entity -> true).forEach(itemEntity -> {
                    if (itemEntity.m_32055_().m_204117_(ENDERITE_ITEMS_TAG) && itemEntity.m_20186_() < voidThreshold) {
                        itemEntity.m_6034_(itemEntity.m_20185_(), teleportY, itemEntity.m_20189_());
                        BlockPos centerPos = new BlockPos((int)itemEntity.m_20185_(), (int)platformY, (int)itemEntity.m_20189_());
                        for (int dx = -1; dx <= 1; ++dx) {
                            for (int dz = -1; dz <= 1; ++dz) {
                                BlockPos currentPos = centerPos.m_7918_(dx, 0, dz);
                                if (!world.m_8055_(currentPos).m_60795_()) continue;
                                world.m_7731_(currentPos, Blocks.f_50259_.m_49966_(), 3);
                            }
                        }
                        itemEntity.f_19812_ = true;
                        itemEntity.m_6853_(false);
                        Vec3 currentMotion = itemEntity.m_20184_();
                        itemEntity.m_20256_(new Vec3(currentMotion.f_82479_, -0.01, currentMotion.f_82481_));
                        if (RANDOM.nextFloat() < 0.1f) {
                            world.m_6263_(null, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), SoundEvents.f_215671_, SoundSource.MASTER, 1.0f, 0.8f);
                        }
                        if (world instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)world;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), 10, 0.1, 0.1, 0.1, 0.05);
                        }
                    }
                });
            }
        }
    }
}

