/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.capabilities;

import com.min01.morph.capabilities.IMorphCapability;
import com.min01.morph.capabilities.MorphCapabilityImpl;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class MorphCapabilities {
    public static final Capability<IMorphCapability> MORPH = CapabilityManager.get((CapabilityToken)new CapabilityToken<IMorphCapability>(){});

    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> e) {
        Object object = e.getObject();
        if (object instanceof LivingEntity) {
            final LivingEntity living = (LivingEntity)object;
            e.addCapability(IMorphCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundTag>(){
                LazyOptional<IMorphCapability> inst = LazyOptional.of(() -> {
                    MorphCapabilityImpl i = new MorphCapabilityImpl();
                    i.setEntity(living);
                    return i;
                });

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return MORPH.orEmpty(capability, this.inst.cast());
                }

                public CompoundTag serializeNBT() {
                    return (CompoundTag)((IMorphCapability)this.inst.orElseThrow(NullPointerException::new)).serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    ((IMorphCapability)this.inst.orElseThrow(NullPointerException::new)).deserializeNBT((Tag)nbt);
                }
            });
        }
    }
}

