/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.capabilities;

import com.min01.morph.capabilities.IMorphCapability;
import com.min01.morph.entity.AbstractOwnableMob;
import com.min01.morph.entity.EntityFakeTarget;
import com.min01.morph.entity.MorphEntities;
import com.min01.morph.network.MorphNetwork;
import com.min01.morph.network.UpdateMorphPacket;
import com.min01.morph.util.MorphUtil;
import com.min01.morph.util.world.MorphSavedData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class MorphCapabilityImpl
implements IMorphCapability {
    private LivingEntity entity;
    private LivingEntity morph;
    private LivingEntity target;
    private EntityType<?> type;
    private boolean isPersistent;
    private boolean changedDimension;
    private List<Map<String, String>> dataList = new ArrayList<Map<String, String>>();

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag datas = new ListTag();
        this.dataList.forEach(t -> {
            for (Map.Entry entry : t.entrySet()) {
                String dataName = (String)entry.getKey();
                String dataValue = (String)entry.getValue();
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("DataName", dataName);
                tag.m_128359_("DataValue", dataValue);
                datas.add((Object)tag);
            }
        });
        if (this.type != null) {
            nbt.m_128359_("MorphType", ForgeRegistries.ENTITY_TYPES.getKey(this.type).toString());
        }
        nbt.m_128379_("isPersistent", this.isPersistent);
        nbt.m_128379_("ChangedDimension", this.changedDimension);
        nbt.m_128365_("MobDatas", (Tag)datas);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("MorphType")) {
            this.type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(nbt.m_128461_("MorphType")));
        }
        ListTag datas = nbt.m_128437_("MobDatas", 11);
        for (int i = 0; i < datas.size(); ++i) {
            CompoundTag tag = datas.m_128728_(i);
            HashMap<String, String> map = new HashMap<String, String>();
            String dataName = tag.m_128461_("DataName");
            String dataValue = tag.m_128461_("DataValue");
            map.put(dataName, dataValue);
            this.dataList.add(map);
        }
        this.isPersistent = nbt.m_128471_("isPersistent");
        this.changedDimension = nbt.m_128471_("ChangedDimension");
    }

    @Override
    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public void tick() {
        if (this.morph != null) {
            MorphUtil.tick(this.entity, this.morph);
            this.morph.m_8119_();
            LivingEntity livingEntity = this.morph;
            if (livingEntity instanceof AbstractPiglin) {
                AbstractPiglin piglin = (AbstractPiglin)livingEntity;
                piglin.m_34670_(true);
            }
            if ((livingEntity = this.morph) instanceof Hoglin) {
                Hoglin hoglin = (Hoglin)livingEntity;
                hoglin.m_34564_(true);
            }
            if ((livingEntity = this.entity) instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_20242_(this.morph.m_20068_());
                if (!player.m_150110_().f_35937_ && !player.m_5833_()) {
                    MoveControl control = ((Mob)this.morph).m_21566_();
                    PathNavigation navigation = ((Mob)this.morph).m_21573_();
                    if (control instanceof FlyingMoveControl || navigation instanceof FlyingPathNavigation || control.getClass().getSimpleName().contains("Flight") || navigation.getClass().getSimpleName().contains("Flight")) {
                        if (!player.m_150110_().f_35936_) {
                            player.m_150110_().f_35936_ = true;
                            player.m_6885_();
                        }
                    } else if (player.m_150110_().f_35936_) {
                        player.m_150110_().f_35935_ = false;
                        player.m_150110_().f_35936_ = false;
                        player.m_6885_();
                    }
                }
            }
            if (!this.entity.f_19853_.f_46443_) {
                if (this.target == null || !this.target.m_6084_()) {
                    EntityFakeTarget target = new EntityFakeTarget((EntityType<? extends AbstractOwnableMob<?>>)((EntityType)MorphEntities.FAKE_TARGET.get()), this.entity.f_19853_);
                    target.setOwner(this.entity);
                    this.entity.f_19853_.m_7967_((Entity)target);
                    this.target = target;
                }
                if (!(this.morph.m_6084_() || this.morph.m_146911_().equals((Object)Entity.RemovalReason.CHANGED_DIMENSION) || this.isPersistent)) {
                    MorphUtil.removeMorph(this.entity);
                }
            }
        } else if (this.type != null) {
            this.setMorph((LivingEntity)this.type.m_20615_(this.entity.f_19853_));
        }
    }

    @Override
    public void setPersistent(boolean isPersistent) {
        this.isPersistent = isPersistent;
    }

    @Override
    public boolean isPersistent() {
        return this.isPersistent;
    }

    @Override
    public void setMorph(LivingEntity morph) {
        if (this.morph != null) {
            this.morph.m_146870_();
        }
        if (morph != null) {
            if (morph.m_19879_() > 0) {
                int number = this.entity.f_19853_.f_46441_.m_216339_(1, 1000);
                morph.m_20234_(-number);
            }
            this.setType(morph.m_6095_());
            this.setup((Mob)morph);
            MorphUtil.ENTITY_MAP.put(morph.getClass().hashCode(), (Entity)morph);
            MorphUtil.ENTITY_MAP2.put(morph.getClass().getSuperclass().hashCode(), (Entity)morph);
        }
        this.morph = morph;
        this.sendUpdataPacket();
    }

    public void setup(Mob mob) {
        if (!mob.f_19853_.f_46443_) {
            MorphSavedData data;
            if (this.isPersistent) {
                this.dataList.forEach(t -> {
                    for (Map.Entry entry : t.entrySet()) {
                        String dataName = (String)entry.getKey();
                        String dataValue = (String)entry.getValue();
                        MorphUtil.setData(mob, dataName, dataValue);
                    }
                });
            }
            if ((data = MorphSavedData.get(mob.f_19853_)) != null) {
                data.saveData(mob.getClass().getSimpleName(), MorphUtil.getDatas(mob.getClass()));
                data.saveGoal(mob.getClass().getSimpleName(), MorphUtil.getGoals(mob));
                data.saveAnimation(mob.getClass().getSimpleName(), MorphUtil.getAnimations(mob.getClass()));
            }
            ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)((ServerLevelAccessor)this.entity.f_19853_), (DifficultyInstance)this.entity.f_19853_.m_6436_(this.entity.m_20183_()), (MobSpawnType)MobSpawnType.COMMAND, null, null);
        }
    }

    @Override
    public LivingEntity getMorph() {
        return this.morph;
    }

    @Override
    public void setType(EntityType<?> type) {
        this.type = type;
    }

    @Override
    public EntityType<?> getType() {
        return this.type;
    }

    @Override
    public LivingEntity getFakeTarget() {
        return this.target;
    }

    @Override
    public void setData(LivingEntity living, String dataName, String dataValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(dataName, dataValue);
        this.dataList.add(map);
    }

    @Override
    public void setChangedDimension(boolean isChangedDimension) {
        this.changedDimension = true;
    }

    @Override
    public boolean isChangedDimension() {
        return this.changedDimension;
    }

    public void sendUpdataPacket() {
        if (!this.entity.f_19853_.f_46443_) {
            if (this.morph != null && this.type != null) {
                MorphNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.entity), (Object)new UpdateMorphPacket(this.entity, this.type, this.morph.m_19879_(), false));
            } else {
                MorphNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.entity), (Object)new UpdateMorphPacket(this.entity, EntityType.f_20510_, 0, true));
            }
        }
    }
}

