/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.command;

import com.google.common.collect.Lists;
import com.min01.morph.capabilities.IMorphCapability;
import com.min01.morph.capabilities.MorphCapabilities;
import com.min01.morph.capabilities.MorphCapabilityImpl;
import com.min01.morph.entity.MorphEntities;
import com.min01.morph.misc.IWrappedGoal;
import com.min01.morph.util.MorphUtil;
import com.min01.morph.util.world.MorphSavedData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraftforge.registries.ForgeRegistries;

public class MorphCommand {
    public static List<String> DATA_SUGGESTIONS = new ArrayList<String>();
    public static List<String> GOAL_SUGGESTIONS = new ArrayList<String>();
    public static List<String> ANIMATION_SUGGESTIONS = new ArrayList<String>();
    public static final SuggestionProvider<CommandSourceStack> DATAS = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("datas"), (p_258164_, p_258165_) -> {
        Object patt2116$temp = p_258164_.getSource();
        if (patt2116$temp instanceof CommandSourceStack) {
            MorphSavedData data;
            CommandSourceStack source = (CommandSourceStack)patt2116$temp;
            ServerPlayer player = source.m_230896_();
            if (player != null && (data = MorphSavedData.get(player.f_19853_)) != null) {
                IMorphCapability cap = (IMorphCapability)player.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
                return SharedSuggestionProvider.m_82970_(data.getDatas(cap.getMorph().getClass().getSimpleName()), (SuggestionsBuilder)p_258165_);
            }
        } else {
            return SharedSuggestionProvider.m_82970_(DATA_SUGGESTIONS, (SuggestionsBuilder)p_258165_);
        }
        return SharedSuggestionProvider.m_82981_(Stream.empty(), (SuggestionsBuilder)p_258165_);
    });
    public static final SuggestionProvider<CommandSourceStack> GOALS = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("goals"), (p_258164_, p_258165_) -> {
        Object patt2959$temp = p_258164_.getSource();
        if (patt2959$temp instanceof CommandSourceStack) {
            MorphSavedData data;
            CommandSourceStack source = (CommandSourceStack)patt2959$temp;
            ServerPlayer player = source.m_230896_();
            if (player != null && (data = MorphSavedData.get(player.f_19853_)) != null) {
                IMorphCapability cap = (IMorphCapability)player.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
                return SharedSuggestionProvider.m_82970_(data.getGoals(cap.getMorph().getClass().getSimpleName()), (SuggestionsBuilder)p_258165_);
            }
        } else {
            return SharedSuggestionProvider.m_82970_(GOAL_SUGGESTIONS, (SuggestionsBuilder)p_258165_);
        }
        return SharedSuggestionProvider.m_82981_(Stream.empty(), (SuggestionsBuilder)p_258165_);
    });
    public static final SuggestionProvider<CommandSourceStack> ANIMATIONS = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("animations"), (p_258164_, p_258165_) -> {
        Object patt3812$temp = p_258164_.getSource();
        if (patt3812$temp instanceof CommandSourceStack) {
            MorphSavedData data;
            CommandSourceStack source = (CommandSourceStack)patt3812$temp;
            ServerPlayer player = source.m_230896_();
            if (player != null && (data = MorphSavedData.get(player.f_19853_)) != null) {
                IMorphCapability cap = (IMorphCapability)player.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
                return SharedSuggestionProvider.m_82970_(data.getAnimations(cap.getMorph().getClass().getSimpleName()), (SuggestionsBuilder)p_258165_);
            }
        } else {
            return SharedSuggestionProvider.m_82970_(ANIMATION_SUGGESTIONS, (SuggestionsBuilder)p_258165_);
        }
        return SharedSuggestionProvider.m_82981_(Stream.empty(), (SuggestionsBuilder)p_258165_);
    });
    public static final SuggestionProvider<CommandSourceStack> ENTITIES = SuggestionProviders.m_121658_((ResourceLocation)new ResourceLocation("entities"), (p_258164_, p_258165_) -> SharedSuggestionProvider.m_82960_(ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(p_247987_ -> p_247987_.m_245993_(((SharedSuggestionProvider)p_258164_.getSource()).m_245239_()) && p_247987_ != MorphEntities.FAKE_TARGET.get()), (SuggestionsBuilder)p_258165_, EntityType::m_20613_, p_212436_ -> Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)EntityType.m_20613_((EntityType)p_212436_)))));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"morph").requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"morphTarget", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)ctx, (ResourceKey)Registries.f_256939_)).suggests(ENTITIES).then(Commands.m_82129_((String)"persistent", (ArgumentType)BoolArgumentType.bool()).executes(commandCtx -> MorphCommand.morph((CommandSourceStack)commandCtx.getSource(), EntityArgument.m_91477_((CommandContext)commandCtx, (String)"players"), ResourceArgument.m_246260_((CommandContext)commandCtx, (String)"morphTarget"), BoolArgumentType.getBool((CommandContext)commandCtx, (String)"persistent")))))))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"morphTarget", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)ctx, (ResourceKey)Registries.f_256939_)).suggests(ENTITIES).executes(commandCtx -> MorphCommand.morph((CommandSourceStack)commandCtx.getSource(), EntityArgument.m_91477_((CommandContext)commandCtx, (String)"players"), ResourceArgument.m_246260_((CommandContext)commandCtx, (String)"morphTarget"), false)))))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"trigger").then(Commands.m_82129_((String)"goalName", (ArgumentType)StringArgumentType.string()).suggests(GOALS).executes(commandCtx -> MorphCommand.triggerGoal((CommandSourceStack)commandCtx.getSource(), EntityArgument.m_91477_((CommandContext)commandCtx, (String)"players"), StringArgumentType.getString((CommandContext)commandCtx, (String)"goalName"))))))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"trigger").then(Commands.m_82129_((String)"goalName", (ArgumentType)StringArgumentType.string()).suggests(GOALS).then(Commands.m_82129_((String)"animationName", (ArgumentType)StringArgumentType.string()).suggests(ANIMATIONS).executes(commandCtx -> MorphCommand.triggerGoalWithAnimation((CommandSourceStack)commandCtx.getSource(), EntityArgument.m_91477_((CommandContext)commandCtx, (String)"players"), StringArgumentType.getString((CommandContext)commandCtx, (String)"goalName"), StringArgumentType.getString((CommandContext)commandCtx, (String)"animationName")))))))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"data").then(Commands.m_82129_((String)"dataName", (ArgumentType)StringArgumentType.string()).suggests(DATAS).then(Commands.m_82129_((String)"dataValue", (ArgumentType)StringArgumentType.string()).executes(commandCtx -> MorphCommand.setData((CommandSourceStack)commandCtx.getSource(), EntityArgument.m_91477_((CommandContext)commandCtx, (String)"players"), StringArgumentType.getString((CommandContext)commandCtx, (String)"dataName"), StringArgumentType.getString((CommandContext)commandCtx, (String)"dataValue")))))))).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"reset").executes(commandCtx -> MorphCommand.unmorph((CommandSourceStack)commandCtx.getSource(), EntityArgument.m_91477_((CommandContext)commandCtx, (String)"players"))))));
    }

    private static int triggerGoal(CommandSourceStack sourceStack, Collection<ServerPlayer> players, String goalName) {
        for (ServerPlayer player : players) {
            player.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
                if (t.getMorph() != null) {
                    Mob mob = (Mob)t.getMorph();
                    Set set = mob.f_21345_.m_148105_();
                    ArrayList list = Lists.newArrayList((Iterable)set);
                    for (WrappedGoal goal : set) {
                        int index = list.indexOf(goal);
                        char lastChar = goalName.charAt(goalName.length() - 1);
                        String name = MorphUtil.getGoalName(goal.m_26015_());
                        if (index != Character.getNumericValue(lastChar) && !name.equals(goalName)) continue;
                        ((IWrappedGoal)goal).setCanUse();
                        MorphUtil.setTarget((LivingEntity)player, mob, goal, t.getFakeTarget());
                        goal.m_8056_();
                        sourceStack.m_288197_(() -> Component.m_237113_((String)("Triggered goal " + goalName)), true);
                        break;
                    }
                } else {
                    sourceStack.m_81352_((Component)Component.m_237113_((String)"Player doesn't morphed to anything"));
                }
            });
        }
        return players.size();
    }

    private static int triggerGoalWithAnimation(CommandSourceStack sourceStack, Collection<ServerPlayer> players, String goalName, String animationName) {
        for (ServerPlayer player : players) {
            player.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
                if (t.getMorph() != null) {
                    Mob mob = (Mob)t.getMorph();
                    Set set = mob.f_21345_.m_148105_();
                    ArrayList list = Lists.newArrayList((Iterable)set);
                    for (WrappedGoal goal : set) {
                        int index = list.indexOf(goal);
                        char lastChar = goalName.charAt(goalName.length() - 1);
                        String name = MorphUtil.getGoalName(goal.m_26015_());
                        if (index != Character.getNumericValue(lastChar) && !name.equals(goalName)) continue;
                        ((IWrappedGoal)goal).setCanUse();
                        MorphUtil.setTarget((LivingEntity)player, mob, goal, t.getFakeTarget());
                        MorphUtil.setAnimation(mob, animationName);
                        goal.m_8056_();
                        sourceStack.m_288197_(() -> Component.m_237113_((String)("Triggered goal " + goalName + " with animation " + animationName)), true);
                        break;
                    }
                } else {
                    sourceStack.m_81352_((Component)Component.m_237113_((String)"Player doesn't morphed to anything"));
                }
            });
        }
        return players.size();
    }

    private static int setData(CommandSourceStack sourceStack, Collection<ServerPlayer> players, String dataName, String dataValue) {
        for (ServerPlayer player : players) {
            player.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
                if (t.getMorph() != null) {
                    Mob mob = (Mob)t.getMorph();
                    MorphUtil.setData(mob, dataName, dataValue);
                    t.setData((LivingEntity)player, dataName, dataValue);
                    sourceStack.m_288197_(() -> Component.m_237113_((String)("Changed entity data " + dataName + " to " + dataValue)), true);
                }
            });
        }
        return players.size();
    }

    private static int morph(CommandSourceStack sourceStack, Collection<ServerPlayer> players, Holder.Reference<EntityType<?>> entityType, boolean isPersistent) {
        for (ServerPlayer player : players) {
            player.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
                Entity entity;
                if (t.getMorph() != null) {
                    MorphUtil.removeMorph((LivingEntity)player);
                }
                if ((entity = ((EntityType)entityType.get()).m_20615_(player.f_19853_)) instanceof Mob) {
                    Mob mob = (Mob)entity;
                    t.setPersistent(isPersistent);
                    t.setMorph((LivingEntity)mob);
                    player.m_21153_(mob.m_21233_());
                    sourceStack.m_288197_(() -> Component.m_237113_((String)("Changed morph entity of " + player.m_5446_().getString() + " to " + mob.m_5446_().getString())), true);
                } else {
                    sourceStack.m_81352_((Component)Component.m_237113_((String)"Can't morph to none living entity"));
                }
            });
        }
        return players.size();
    }

    private static int unmorph(CommandSourceStack sourceStack, Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            if (MorphUtil.hasMorph((LivingEntity)player)) {
                MorphUtil.removeMorph((LivingEntity)player);
                sourceStack.m_288197_(() -> Component.m_237113_((String)("Removed morph of " + player.m_5446_().getString())), true);
                continue;
            }
            sourceStack.m_81352_((Component)Component.m_237113_((String)"Player doesn't morphed to anything"));
        }
        return players.size();
    }
}

