/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.event;

import com.min01.morph.capabilities.MorphCapabilities;
import com.min01.morph.command.MorphCommand;
import com.min01.morph.util.MorphUtil;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="minsmorph")
public class EventHandlerForge {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        MorphCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        MorphUtil.getMorph((Entity)event.getEntity(), t -> {
            if (t.m_21051_(Attributes.f_22281_) != null) {
                t.m_7327_(event.getTarget());
            }
        });
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (MorphUtil.isMorph(entity)) {
            Entity owner = MorphUtil.getMorphOwner(entity);
            if (owner != null) {
                MorphUtil.setChangedDimension((LivingEntity)owner, true);
            }
            event.setCanceled(true);
            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (MorphUtil.isChangedDimension((LivingEntity)player)) {
            player.getCapability(MorphCapabilities.MORPH).ifPresent(t -> t.setMorph((LivingEntity)t.getType().m_20615_(player.f_19853_)));
            MorphUtil.setChangedDimension((LivingEntity)player, false);
        }
    }

    @SubscribeEvent
    public static void onLivingConversion(LivingConversionEvent.Pre event) {
        if (MorphUtil.isMorph((Entity)event.getEntity())) {
            event.setConversionTimer(0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entityHit;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && MorphUtil.isMorph((entityHit = (EntityHitResult)hitResult).m_82443_())) {
            event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        LivingEntity source;
        Explosion explosion = event.getExplosion();
        if (explosion.m_252906_() != null && MorphUtil.getMorphOwner((Entity)(source = explosion.m_252906_())) != null) {
            Entity owner = MorphUtil.getMorphOwner((Entity)source);
            List list = event.getAffectedEntities();
            if (list.contains(owner) && !list.isEmpty()) {
                list.removeIf(t -> t == owner);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
                if (t.getMorph() != null) {
                    t.setMorph(t.getMorph());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player original = event.getOriginal();
            original.revive();
            Player player = event.getEntity();
            original.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
                if (t.getMorph() != null && t.isPersistent()) {
                    player.getCapability(MorphCapabilities.MORPH).ifPresent(t2 -> {
                        t2.setType(t.getMorph().m_6095_());
                        t2.setPersistent(true);
                    });
                }
            });
        }
    }
}

