/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.mixin;

import com.min01.morph.util.MorphUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity {
    @Inject(at={@At(value="RETURN")}, method={"makeBoundingBox"}, cancellable=true)
    private void makeBoundingBox(CallbackInfoReturnable<AABB> cir) {
        Entity entity = (Entity)Entity.class.cast(this);
        MorphUtil.getMorph(entity, t -> {
            entity.f_19816_ = t.f_19816_;
            cir.setReturnValue((Object)t.f_19815_.m_20393_(t.m_20182_()));
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"isAlliedTo(Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    private void isAlliedTo(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (MorphUtil.getMorphOwner((Entity)Entity.class.cast(this)) != null && entity == MorphUtil.getMorphOwner((Entity)Entity.class.cast(this))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getAirSupply"}, cancellable=true)
    private void getAirSupply(CallbackInfoReturnable<Integer> cir) {
        MorphUtil.getMorph((Entity)Entity.class.cast(this), t -> cir.setReturnValue((Object)t.m_20146_()));
    }

    @Inject(at={@At(value="HEAD")}, method={"setSecondsOnFire"}, cancellable=true)
    private void setSecondsOnFire(int second, CallbackInfo ci) {
        if (MorphUtil.getMorphOwner((Entity)Entity.class.cast(this)) != null) {
            MorphUtil.getMorphOwner((Entity)Entity.class.cast(this)).m_20254_(second);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"fireImmune"}, cancellable=true)
    private void fireImmune(CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)Entity.class.cast(this);
        MorphUtil.getMorph(entity, t -> cir.setReturnValue((Object)t.m_5825_()));
    }

    @Inject(at={@At(value="HEAD")}, method={"causeFallDamage"}, cancellable=true)
    private void causeFallDamage(float distance, float damage, DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)Entity.class.cast(this);
        MorphUtil.getMorph(entity, t -> cir.setReturnValue((Object)t.m_142535_(distance, damage, source)));
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void isInvulnerableTo(DamageSource source, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)Entity.class.cast(this);
        MorphUtil.getMorph(entity, t -> cir.setReturnValue((Object)t.m_6673_(source)));
    }

    @Inject(at={@At(value="HEAD")}, method={"setPos(DDD)V"}, cancellable=true)
    private void setPos(double x, double y, double z, CallbackInfo ci) {
        if (MorphUtil.getMorphOwner((Entity)Entity.class.cast(this)) != null) {
            MorphUtil.getMorphOwner((Entity)Entity.class.cast(this)).m_6034_(x, y, z);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getDeltaMovement"}, cancellable=true)
    private void getDeltaMovement(CallbackInfoReturnable<Vec3> cir) {
        Entity entity = (Entity)this;
        MorphUtil.getMorph(entity, t -> {
            Vec3 playerMove = (Vec3)cir.getReturnValue();
            Vec3 morphMove = t.m_20184_();
            double epsilon = 1.0E-4;
            double x = Math.abs(morphMove.f_82479_) > epsilon ? morphMove.f_82479_ : playerMove.f_82479_;
            double y = Math.abs(morphMove.f_82480_) > epsilon ? morphMove.f_82480_ : playerMove.f_82480_;
            double z = Math.abs(morphMove.f_82481_) > epsilon ? morphMove.f_82481_ : playerMove.f_82481_;
            Vec3 merged = new Vec3(x, y, z);
            cir.setReturnValue((Object)merged);
            if (morphMove.m_82556_() > epsilon * epsilon) {
                t.m_20256_(Vec3.f_82478_);
            }
        });
    }
}

