/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.mixin;

import com.min01.morph.capabilities.IMorphCapability;
import com.min01.morph.capabilities.MorphCapabilities;
import com.min01.morph.capabilities.MorphCapabilityImpl;
import com.min01.morph.mixin.LivingEntityInvoker;
import com.min01.morph.util.MorphUtil;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Spider;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.extensions.IForgeLivingEntity;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
implements IForgeLivingEntity {
    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    private void tick(CallbackInfo ci) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        living.getCapability(MorphCapabilities.MORPH).ifPresent(IMorphCapability::tick);
        if (MorphUtil.isMorph((Entity)living) && MorphUtil.getMorphOwner((Entity)living) == null) {
            living.m_146870_();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onClimbable"}, cancellable=true)
    private void onClimbable(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> {
            if (t instanceof Spider) {
                cir.setReturnValue((Object)living.f_19862_);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getMaxHealth"}, cancellable=true)
    private void getMaxHealth(CallbackInfoReturnable<Float> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> cir.setReturnValue((Object)Float.valueOf((float)t.m_21133_(Attributes.f_22276_))));
    }

    @Inject(at={@At(value="HEAD")}, method={"getHealth"}, cancellable=true)
    private void getHealth(CallbackInfoReturnable<Float> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        if (MorphUtil.getMorphOwner((Entity)living) != null) {
            cir.setReturnValue((Object)Float.valueOf(((LivingEntity)MorphUtil.getMorphOwner((Entity)living)).m_21223_()));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getAttribute"}, cancellable=true)
    private void getAttribute(Attribute attribute, CallbackInfoReturnable<AttributeInstance> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> {
            if (MorphUtil.ATTRIBUTES.contains(attribute) && t.m_21051_(attribute) != null) {
                cir.setReturnValue((Object)t.m_21051_(attribute));
            }
            if (attribute == ForgeMod.SWIM_SPEED.get() && t.m_21051_(Attributes.f_22279_) != null) {
                cir.setReturnValue((Object)t.m_21051_(Attributes.f_22279_));
            }
        });
    }

    @Inject(at={@At(value="RETURN")}, method={"getAttributeValue(Lnet/minecraft/core/Holder;)D"}, cancellable=true)
    private void getAttributeValue(Holder<Attribute> holder, CallbackInfoReturnable<Double> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> {
            if (MorphUtil.ATTRIBUTES.contains(holder.m_203334_()) && t.m_21051_((Attribute)holder.m_203334_()) != null) {
                cir.setReturnValue((Object)((Double)cir.getReturnValue() + t.m_21133_((Attribute)holder.m_203334_())));
            }
            if (holder.m_203334_() == ForgeMod.SWIM_SPEED.get() && t.m_21051_(Attributes.f_22279_) != null) {
                cir.setReturnValue((Object)((Double)cir.getReturnValue() + t.m_21133_(Attributes.f_22279_)));
            }
        });
    }

    @Inject(at={@At(value="RETURN")}, method={"getAttributeValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D"}, cancellable=true)
    private void getAttributeValue(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> {
            if (MorphUtil.ATTRIBUTES.contains(attribute) && t.m_21051_(attribute) != null) {
                cir.setReturnValue((Object)((Double)cir.getReturnValue() + t.m_21133_(attribute)));
            }
            if (attribute == ForgeMod.SWIM_SPEED.get() && t.m_21051_(Attributes.f_22279_) != null) {
                cir.setReturnValue((Object)((Double)cir.getReturnValue() + t.m_21133_(Attributes.f_22279_)));
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getAttributeBaseValue(Lnet/minecraft/core/Holder;)D"}, cancellable=true)
    private void getAttributeBaseValue(Holder<Attribute> holder, CallbackInfoReturnable<Double> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> {
            if (MorphUtil.ATTRIBUTES.contains(holder.m_203334_()) && t.m_21051_((Attribute)holder.m_203334_()) != null) {
                cir.setReturnValue((Object)t.m_21172_((Attribute)holder.m_203334_()));
            }
            if (holder.m_203334_() == ForgeMod.SWIM_SPEED.get() && t.m_21051_(Attributes.f_22279_) != null) {
                cir.setReturnValue((Object)t.m_21172_(Attributes.f_22279_));
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getAttributeBaseValue(Lnet/minecraft/world/entity/ai/attributes/Attribute;)D"}, cancellable=true)
    private void getAttributeBaseValue(Attribute attribute, CallbackInfoReturnable<Double> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> {
            if (MorphUtil.ATTRIBUTES.contains(attribute) && t.m_21051_(attribute) != null) {
                cir.setReturnValue((Object)t.m_21172_(attribute));
            }
            if (attribute == ForgeMod.SWIM_SPEED.get() && t.m_21051_(Attributes.f_22279_) != null) {
                cir.setReturnValue((Object)t.m_21172_(Attributes.f_22279_));
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvertedHealAndHarm"}, cancellable=true)
    private void isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> cir.setReturnValue((Object)t.m_21222_()));
    }

    @Inject(at={@At(value="HEAD")}, method={"updateWalkAnimation"}, cancellable=true)
    private void updateWalkAnimation(float p_268283_, CallbackInfo ci) {
        if (((LivingEntity)LivingEntity.class.cast((Object)this)).f_19853_.f_46443_ && MorphUtil.isMorph((Entity)LivingEntity.class.cast(this))) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt"}, cancellable=true)
    private void hurt(DamageSource source, float damage, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> {
            boolean flag = t.m_6469_(source, damage);
            if (!flag) {
                cir.setReturnValue((Object)flag);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"canBeAffected"}, cancellable=true)
    private void canBeAffected(MobEffectInstance effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> cir.setReturnValue((Object)t.m_7301_(effect)));
    }

    @Inject(at={@At(value="HEAD")}, method={"isSensitiveToWater"}, cancellable=true)
    private void isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> cir.setReturnValue((Object)t.m_6126_()));
    }

    @Inject(at={@At(value="HEAD")}, method={"doPush"}, cancellable=true)
    protected void doPush(Entity entity, CallbackInfo ci) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        if (MorphUtil.getMorphOwner((Entity)living) != null && entity == MorphUtil.getMorphOwner((Entity)living)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    private void addEffect(MobEffectInstance effect, @Nullable Entity entity, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        if (MorphUtil.getMorphOwner((Entity)living) != null) {
            ((LivingEntity)MorphUtil.getMorphOwner((Entity)living)).m_147207_(effect, entity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"heal"})
    private void heal(float amount, CallbackInfo ci) {
        if (MorphUtil.getMorphOwner((Entity)LivingEntity.class.cast(this)) != null) {
            ((LivingEntity)MorphUtil.getMorphOwner((Entity)LivingEntity.class.cast(this))).m_5634_(amount);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"randomTeleport"}, cancellable=true)
    private void randomTeleport(double x, double y, double z, boolean flag, CallbackInfoReturnable<Boolean> cir) {
        if (MorphUtil.getMorphOwner((Entity)Entity.class.cast(this)) != null) {
            ((LivingEntity)MorphUtil.getMorphOwner((Entity)Entity.class.cast(this))).m_20984_(x, y, z, flag);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isAffectedByFluids"}, cancellable=true)
    protected void isAffectedByFluids(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> cir.setReturnValue((Object)((LivingEntityInvoker)t).invokeIsAffectedByFluids()));
    }

    @Inject(at={@At(value="HEAD")}, method={"isPushedByFluid"}, cancellable=true)
    private void isPushedByFluid(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        MorphUtil.getMorph((Entity)living, t -> cir.setReturnValue((Object)t.m_6063_()));
    }

    public boolean isPushedByFluid(FluidType type) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        if (living.getCapability(MorphCapabilities.MORPH).isPresent()) {
            IMorphCapability cap = (IMorphCapability)living.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
            if (MorphUtil.hasMorph(living)) {
                return cap.getMorph().isPushedByFluid(type);
            }
        }
        return this.self().m_6063_() && type.canPushEntity((Entity)this.self());
    }

    public boolean canDrownInFluidType(FluidType type) {
        LivingEntity living = (LivingEntity)LivingEntity.class.cast(this);
        if (living.getCapability(MorphCapabilities.MORPH).isPresent()) {
            IMorphCapability cap = (IMorphCapability)living.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
            if (MorphUtil.hasMorph(living)) {
                return cap.getMorph().canDrownInFluidType(type);
            }
        }
        if (type == ForgeMod.WATER_TYPE.get()) {
            return !this.self().m_6040_();
        }
        return type.canDrownIn(this.self());
    }
}

