/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.mixin;

import com.min01.morph.misc.IWrappedGoal;
import com.min01.morph.util.MorphUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WrappedGoal.class})
public class MixinWrappedGoal
implements IWrappedGoal {
    @Unique
    private Mob mob;
    @Unique
    private LivingEntity target;
    @Unique
    private LivingEntity fakeTarget;
    @Unique
    private boolean canUse;
    @Shadow
    private Goal f_25994_;

    @Inject(at={@At(value="RETURN")}, method={"canUse"}, cancellable=true)
    private void canUse(CallbackInfoReturnable<Boolean> cir) {
        if (this.mob != null && MorphUtil.isMorph((Entity)this.mob)) {
            if (this.mob.getClass().getSimpleName().equals("EntityCorpseWarlock")) {
                cir.setReturnValue((Object)((Boolean)cir.getReturnValue() != false || this.canUse ? 1 : 0));
            } else {
                cir.setReturnValue((Object)this.canUse);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"canContinueToUse"}, cancellable=true)
    private void canContinueToUse(CallbackInfoReturnable<Boolean> cir) {
        if (this.mob != null && MorphUtil.isMorph((Entity)this.mob)) {
            try {
                Method m = this.mob.getClass().getMethod("getAnimationTick", new Class[0]);
                int animationTick = (Integer)m.invoke((Object)this.mob, new Object[0]);
                cir.setReturnValue((Object)(animationTick > 0 ? 1 : 0));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    private void tick(CallbackInfo ci) {
        if (this.mob != null && MorphUtil.isMorph((Entity)this.mob)) {
            if (this.target != null) {
                if (this.target.m_6084_()) {
                    this.mob.m_6710_(this.target);
                } else {
                    this.target = null;
                }
            } else if (this.fakeTarget != null) {
                this.mob.m_6710_(this.fakeTarget);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"stop"}, cancellable=true)
    private void stop(CallbackInfo ci) {
        if (this.mob != null && MorphUtil.isMorph((Entity)this.mob)) {
            this.mob.m_6710_(null);
            this.canUse = false;
            this.target = null;
            this.fakeTarget = null;
        }
    }

    @Override
    public void setEntity(Mob mob) {
        this.mob = mob;
    }

    @Override
    public void setFakeTarget(LivingEntity target) {
        this.fakeTarget = target;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @Override
    public void setCanUse() {
        this.canUse = true;
    }
}

