/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.network;

import com.min01.morph.capabilities.MorphCapabilities;
import com.min01.morph.util.MorphUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class UpdateMorphPacket {
    private final UUID entityUUID;
    private final EntityType<?> type;
    private final int entityId;
    private final boolean reset;

    public UpdateMorphPacket(LivingEntity entity, EntityType<?> type, int entityId, boolean reset) {
        this.entityUUID = entity.m_20148_();
        this.type = type;
        this.entityId = entityId;
        this.reset = reset;
    }

    public UpdateMorphPacket(FriendlyByteBuf buf) {
        this.entityUUID = buf.m_130259_();
        this.type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(buf.m_130281_());
        this.entityId = buf.readInt();
        this.reset = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(this.type));
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.reset);
    }

    public static class Handler {
        public static boolean onMessage(UpdateMorphPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    ((Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide())).filter(ClientLevel.class::isInstance).ifPresent(level -> {
                        LivingEntity entity = (LivingEntity)MorphUtil.getEntityByUUID(level, message.entityUUID);
                        if (entity != null) {
                            entity.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
                                if (!message.reset) {
                                    LivingEntity living = (LivingEntity)message.type.m_20615_(level);
                                    living.m_20234_(message.entityId);
                                    t.setMorph(living);
                                } else {
                                    MorphUtil.removeMorph(entity);
                                }
                            });
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

