/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.network;

import com.min01.morph.command.MorphCommand;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.network.NetworkEvent;

public class UpdateMorphSuggestionsPacket {
    private final String suggestionType;
    private final List<String> suggestions;

    public UpdateMorphSuggestionsPacket(String suggestionType, List<String> suggestions) {
        this.suggestionType = suggestionType;
        this.suggestions = suggestions;
    }

    public UpdateMorphSuggestionsPacket(FriendlyByteBuf buf) {
        this.suggestionType = buf.m_130277_();
        this.suggestions = buf.m_236845_(FriendlyByteBuf::m_130277_);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.suggestionType);
        buf.m_236828_(this.suggestions, FriendlyByteBuf::m_130070_);
    }

    public static class Handler {
        public static boolean onMessage(UpdateMorphSuggestionsPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    ((Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide())).filter(ClientLevel.class::isInstance).ifPresent(level -> {
                        List<String> suggestions = message.suggestions;
                        String type = message.suggestionType;
                        if (type.equals("Data")) {
                            MorphCommand.DATA_SUGGESTIONS = suggestions;
                        } else if (type.equals("Goal")) {
                            MorphCommand.GOAL_SUGGESTIONS = suggestions;
                        } else if (type.equals("Animation")) {
                            MorphCommand.ANIMATION_SUGGESTIONS = suggestions;
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

