/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.util;

import com.google.common.collect.Lists;
import com.min01.morph.capabilities.IMorphCapability;
import com.min01.morph.capabilities.MorphCapabilities;
import com.min01.morph.capabilities.MorphCapabilityImpl;
import com.min01.morph.misc.ILevelEntityGetterAdapter;
import com.min01.morph.misc.IWrappedGoal;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MorphUtil {
    public static final Map<Integer, Entity> ENTITY_MAP = new HashMap<Integer, Entity>();
    public static final Map<Integer, Entity> ENTITY_MAP2 = new HashMap<Integer, Entity>();
    public static final List<Attribute> ATTRIBUTES = Lists.newArrayList((Object[])new Attribute[]{Attributes.f_22284_, Attributes.f_22285_, Attributes.f_22281_, Attributes.f_22282_, Attributes.f_22280_, Attributes.f_22277_, Attributes.f_22288_, Attributes.f_22278_, Attributes.f_22276_});
    public static final Method GET_ENTITY = ObfuscationReflectionHelper.findMethod(Level.class, (String)"m_142646_", (Class[])new Class[0]);

    public static void setTarget(LivingEntity owner, Mob morph, LivingEntity fakeTarget) {
        EntityHitResult entityHit;
        Entity entity2;
        morph.m_6710_(fakeTarget);
        HitResult hitResult = ProjectileUtil.m_278180_((Entity)owner, entity -> !entity.m_7307_((Entity)owner), (double)30.0);
        if (hitResult instanceof EntityHitResult && (entity2 = (entityHit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            morph.m_6710_(living);
        }
    }

    public static void setTarget(LivingEntity owner, Mob morph, WrappedGoal goal, LivingEntity fakeTarget) {
        EntityHitResult entityHit;
        Entity entity2;
        ((IWrappedGoal)goal).setFakeTarget(fakeTarget);
        morph.m_6710_(fakeTarget);
        HitResult hitResult = ProjectileUtil.m_278180_((Entity)owner, entity -> !entity.m_7307_((Entity)owner), (double)30.0);
        if (hitResult instanceof EntityHitResult && (entity2 = (entityHit = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            ((IWrappedGoal)goal).setTarget(living);
            morph.m_6710_(living);
        }
    }

    public static void getMorph(Entity entity, Consumer<LivingEntity> consumer) {
        entity.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
            LivingEntity morph = t.getMorph();
            if (morph != null) {
                consumer.accept(morph);
            }
        });
    }

    public static boolean isMorph(Entity entity) {
        return entity.m_19879_() < 0;
    }

    public static void setChangedDimension(LivingEntity living, boolean value) {
        IMorphCapability cap = (IMorphCapability)living.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
        cap.setChangedDimension(value);
    }

    public static boolean isChangedDimension(LivingEntity living) {
        IMorphCapability cap = (IMorphCapability)living.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
        return cap.isChangedDimension();
    }

    public static boolean isPersistent(LivingEntity living) {
        IMorphCapability cap = (IMorphCapability)living.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
        return cap.isPersistent();
    }

    public static boolean hasMorph(LivingEntity living) {
        IMorphCapability cap = (IMorphCapability)living.getCapability(MorphCapabilities.MORPH).orElse((Object)new MorphCapabilityImpl());
        return cap.getMorph() != null;
    }

    public static void removeMorph(LivingEntity living) {
        living.getCapability(MorphCapabilities.MORPH).ifPresent(t -> {
            if (MorphUtil.hasMorph(living)) {
                if (living instanceof Player) {
                    Player player = (Player)living;
                    if (!player.m_150110_().f_35937_) {
                        player.m_150110_().f_35935_ = false;
                        player.m_150110_().f_35936_ = false;
                        player.m_20242_(false);
                        player.m_6885_();
                    }
                }
                t.setMorph(null);
                t.setType(null);
                t.setPersistent(false);
                living.m_5634_(living.m_21233_());
                living.m_6210_();
            }
        });
    }

    public static String getGoalName(Goal goal) {
        String name = goal.getClass().getSimpleName();
        if (goal.getClass().isAnonymousClass()) {
            name = goal.getClass().getSuperclass().getSimpleName();
        }
        return name;
    }

    public static void setData(Mob mob, String dataName, String dataValue) {
        block12: {
            try {
                Field f = mob.getClass().getDeclaredField(dataName);
                f.setAccessible(true);
                if (dataValue.equalsIgnoreCase("true") || dataValue.equalsIgnoreCase("false")) {
                    EntityDataAccessor accessor = (EntityDataAccessor)f.get(mob);
                    if (accessor.m_135016_() == EntityDataSerializers.f_135035_) {
                        mob.m_20088_().m_135381_(accessor, (Object)Boolean.parseBoolean(dataValue));
                    }
                    break block12;
                }
                if (dataValue.contains(".")) {
                    try {
                        float value = Float.parseFloat(dataValue);
                        EntityDataAccessor accessor = (EntityDataAccessor)f.get(mob);
                        if (accessor.m_135016_() == EntityDataSerializers.f_135029_) {
                            mob.m_20088_().m_135381_(accessor, (Object)Float.valueOf(value));
                        }
                        break block12;
                    }
                    catch (NumberFormatException value) {}
                    break block12;
                }
                try {
                    int value = Integer.parseInt(dataValue);
                    EntityDataAccessor accessor = (EntityDataAccessor)f.get(mob);
                    if (accessor.m_135016_() == EntityDataSerializers.f_135028_) {
                        mob.m_20088_().m_135381_(accessor, (Object)value);
                    }
                }
                catch (NumberFormatException e) {
                    EntityDataAccessor accessor = (EntityDataAccessor)f.get(mob);
                    if (accessor.m_135016_() == EntityDataSerializers.f_135030_) {
                        mob.m_20088_().m_135381_(accessor, (Object)dataValue);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    public static void setAnimation(Mob mob, String animationName) {
        Method m;
        Field f2;
        try {
            f2 = mob.getClass().getDeclaredField(animationName);
            m = mob.getClass().getMethod("setAnimation", f2.getType());
            f2.setAccessible(true);
            m.invoke((Object)mob, f2.get(mob));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException f2) {
            // empty catch block
        }
        try {
            f2 = mob.getClass().getDeclaredField(animationName);
            m = mob.getClass().getMethod("sendAbilityMessage", f2.getType());
            f2.setAccessible(true);
            m.invoke((Object)mob, f2.get(mob));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException f3) {
            // empty catch block
        }
        try {
            f2 = mob.getClass().getDeclaredField(animationName);
            f2.setAccessible(true);
            m = f2.getType().getMethod("play", Entity.class, Integer.TYPE);
            m.invoke(f2.get(mob), mob, 100);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static List<String> getDatas(Class<?> clazz) {
        ArrayList<String> list = new ArrayList<String>();
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getType().getSimpleName().equals("EntityDataAccessor")) continue;
            list.add(f.getName());
        }
        for (Field f : clazz.getSuperclass().getDeclaredFields()) {
            if (!f.getType().getSimpleName().equals("EntityDataAccessor")) continue;
            list.add(f.getName());
        }
        return list;
    }

    public static List<String> getGoals(Mob mob) {
        ArrayList<String> list = new ArrayList<String>();
        Set set = mob.f_21345_.m_148105_();
        ArrayList goals = Lists.newArrayList((Iterable)set);
        for (WrappedGoal goal : set) {
            ((IWrappedGoal)goal).setEntity(mob);
            Object goalName = goal.m_26015_().getClass().getSimpleName();
            if (goal.m_26015_().getClass().isAnonymousClass()) {
                goalName = goal.m_26015_().getClass().getSuperclass().getSimpleName();
            }
            if (list.contains(goalName)) {
                goalName = (String)goalName + goals.indexOf(goal);
            }
            list.add((String)goalName);
        }
        return list;
    }

    public static List<String> getAnimations(Class<?> clazz) {
        ArrayList<String> list = new ArrayList<String>();
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getType().getSimpleName().contains("Animation") || f.getType().isArray()) continue;
            list.add(f.getName());
        }
        for (Field f : clazz.getSuperclass().getDeclaredFields()) {
            if (!f.getType().getSimpleName().contains("Animation") || f.getType().isArray()) continue;
            list.add(f.getName());
        }
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getType().getSimpleName().contains("AbilityType") || f.getType().isArray()) continue;
            list.add(f.getName());
        }
        return list;
    }

    public static void getMethodCalls(Class<?> clazz, Consumer<MethodInsnNode> consumer) {
        try {
            ClassNode classNode = MorphUtil.getClassNode(clazz);
            for (MethodNode method : classNode.methods) {
                for (AbstractInsnNode ain : method.instructions.toArray()) {
                    if (ain.getType() != 5) continue;
                    MethodInsnNode min = (MethodInsnNode)ain;
                    consumer.accept(min);
                }
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
    }

    public static void getFieldCalls(Class<?> clazz, Consumer<FieldInsnNode> consumer) {
        try {
            ClassNode classNode = MorphUtil.getClassNode(clazz);
            for (MethodNode method : classNode.methods) {
                for (AbstractInsnNode ain : method.instructions.toArray()) {
                    if (ain.getType() != 4) continue;
                    FieldInsnNode fin = (FieldInsnNode)ain;
                    consumer.accept(fin);
                }
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
    }

    public static ClassNode getClassNode(Class<?> clazz) throws IOException {
        String className = clazz.getName().replace('.', '/') + ".class";
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try (InputStream classStream = classLoader.getResourceAsStream(className);){
            if (classStream == null) {
                throw new IOException("Class not found: " + clazz.getName());
            }
            ClassReader classReader = new ClassReader(classStream);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            ClassNode classNode2 = classNode;
            return classNode2;
        }
    }

    public static void tick(LivingEntity player, LivingEntity morph) {
        morph.getPersistentData().m_128362_("MorphOwnerUUID", player.m_20148_());
        player.f_19816_ = morph.f_19816_;
        player.f_19815_ = morph.f_19815_;
        player.m_6210_();
        if (!player.m_6084_()) {
            morph.m_146870_();
        } else {
            MorphUtil.sync(morph, player);
            for (Entity entity : morph.m_20197_()) {
                MorphUtil.tickPassenger((Entity)morph, entity);
            }
            try {
                ILevelEntityGetterAdapter adapter = (ILevelEntityGetterAdapter)GET_ENTITY.invoke((Object)player.f_19853_, new Object[0]);
                adapter.byId().putIfAbsent(morph.m_19879_(), (Object)morph);
                adapter.byId().values().removeIf(t -> !t.m_6084_());
                adapter.byUuid().putIfAbsent(morph.m_20148_(), (Entity)morph);
                adapter.byUuid().values().removeIf(t -> !t.m_6084_());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (morph instanceof Mob) {
                Mob mob = (Mob)morph;
                if (!player.f_19853_.f_46443_) {
                    MorphUtil.serverAiStep(mob);
                }
                if (mob.m_5448_() != null && !mob.m_5448_().m_6084_()) {
                    mob.m_6710_(null);
                }
            }
        }
    }

    public static void tickPassenger(Entity vehicle, Entity passenger) {
        if (passenger.m_20202_() == vehicle) {
            passenger.m_6083_();
            for (Entity entity : passenger.m_20197_()) {
                MorphUtil.tickPassenger(passenger, entity);
            }
        }
    }

    public static void sync(LivingEntity morph, LivingEntity player) {
        morph.f_19797_ = player.f_19797_;
        morph.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        morph.f_19790_ = player.f_19790_;
        morph.f_19791_ = player.f_19791_;
        morph.f_19792_ = player.f_19792_;
        morph.f_19854_ = player.f_19854_;
        morph.f_19855_ = player.f_19855_;
        morph.f_19856_ = player.f_19856_;
        morph.f_19859_ = player.f_19859_;
        morph.f_19860_ = player.f_19860_;
        morph.f_20885_ = player.f_20885_;
        morph.f_20886_ = player.f_20886_;
        morph.f_20883_ = player.f_20883_;
        morph.f_20884_ = player.f_20884_;
        morph.f_267362_ = player.f_267362_;
        morph.f_19862_ = player.f_19862_;
        morph.f_19863_ = player.f_19863_;
        morph.m_6853_(player.m_20096_());
        morph.m_20282_(player.m_6069_());
        morph.m_6858_(player.m_20142_());
        morph.f_20916_ = player.f_20916_;
        morph.f_20919_ = player.f_20919_;
        morph.f_19789_ = player.f_19789_;
        morph.f_20913_ = player.f_20913_;
        morph.f_20911_ = player.f_20911_;
        morph.f_20912_ = player.f_20912_;
        morph.f_20921_ = player.f_20921_;
        morph.f_20920_ = player.f_20920_;
    }

    public static void serverAiStep(Mob mob) {
        mob.m_21310_(mob.m_21216_() + 1);
        mob.f_19853_.m_46473_().m_6180_("sensing");
        mob.m_21574_().m_26789_();
        mob.f_19853_.m_46473_().m_7238_();
        int i = mob.f_19853_.m_7654_().m_129921_() + mob.m_19879_();
        if (i % 2 != 0 && mob.f_19797_ > 1) {
            mob.f_19853_.m_46473_().m_6180_("goalSelector");
            mob.f_21345_.m_186081_(false);
            mob.f_19853_.m_46473_().m_7238_();
        } else {
            mob.f_19853_.m_46473_().m_6180_("goalSelector");
            mob.f_21345_.m_25373_();
            mob.f_19853_.m_46473_().m_7238_();
        }
        mob.f_19853_.m_46473_().m_6180_("navigation");
        mob.m_21573_().m_7638_();
        mob.f_19853_.m_46473_().m_7238_();
        mob.f_19853_.m_46473_().m_6180_("mob tick");
        MorphUtil.customServerAiStep(mob);
        mob.f_19853_.m_46473_().m_7238_();
        mob.f_19853_.m_46473_().m_6180_("controls");
        mob.f_19853_.m_46473_().m_6180_("move");
        mob.m_21566_().m_8126_();
        mob.f_19853_.m_46473_().m_6182_("look");
        mob.m_21563_().m_8128_();
        mob.f_19853_.m_46473_().m_6182_("jump");
        mob.m_21569_().m_8124_();
        mob.f_19853_.m_46473_().m_7238_();
        mob.f_19853_.m_46473_().m_7238_();
        DebugPackets.m_133699_((Level)mob.f_19853_, (Mob)mob, (GoalSelector)mob.f_21345_);
    }

    public static void customServerAiStep(Mob mob) {
        Method m = ObfuscationReflectionHelper.findMethod(Mob.class, (String)"m_8024_", (Class[])new Class[0]);
        try {
            m.invoke((Object)mob, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Entity getMorphOwner(Entity entity) {
        if (entity.getPersistentData().m_128441_("MorphOwnerUUID")) {
            return MorphUtil.getEntityByUUID(entity.f_19853_, entity.getPersistentData().m_128342_("MorphOwnerUUID"));
        }
        return null;
    }

    public static Entity getEntityByUUID(Level level, UUID uuid) {
        try {
            LevelEntityGetter entities = (LevelEntityGetter)GET_ENTITY.invoke((Object)level, new Object[0]);
            return (Entity)entities.m_142694_(uuid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

