/*
 * Decompiled with CFR 0.152.
 */
package com.min01.morph.util.world;

import com.min01.morph.network.MorphNetwork;
import com.min01.morph.network.UpdateMorphSuggestionsPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class MorphSavedData
extends SavedData {
    public static final String NAME = "morph_data";
    private Map<String, List<String>> animationMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> goalMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> dataMap = new HashMap<String, List<String>>();

    public static MorphSavedData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DimensionDataStorage storage = serverLevel.m_8895_();
            MorphSavedData data = (MorphSavedData)storage.m_164861_(MorphSavedData::load, MorphSavedData::new, NAME);
            return data;
        }
        return null;
    }

    public static MorphSavedData load(CompoundTag nbt) {
        CompoundTag tag1;
        int i1;
        ArrayList<String> list1;
        ListTag list;
        String mobName;
        CompoundTag tag;
        int i;
        MorphSavedData data = new MorphSavedData();
        ListTag animations = nbt.m_128437_("MobAnimations", 10);
        ListTag goals = nbt.m_128437_("MobGoals", 10);
        ListTag datas = nbt.m_128437_("MobDatas", 10);
        for (i = 0; i < animations.size(); ++i) {
            tag = animations.m_128728_(i);
            mobName = tag.m_128461_("Mob");
            list = tag.m_128437_("Animations", 10);
            list1 = new ArrayList<String>();
            for (i1 = 0; i1 < list.size(); ++i1) {
                tag1 = list.m_128728_(i1);
                list1.add(tag1.m_128461_("Animation"));
            }
            data.saveAnimation(mobName, list1);
        }
        for (i = 0; i < goals.size(); ++i) {
            tag = goals.m_128728_(i);
            mobName = tag.m_128461_("Mob");
            list = tag.m_128437_("Goals", 10);
            list1 = new ArrayList();
            for (i1 = 0; i1 < list.size(); ++i1) {
                tag1 = list.m_128728_(i1);
                list1.add(tag1.m_128461_("Goal"));
            }
            data.saveGoal(mobName, list1);
        }
        for (i = 0; i < datas.size(); ++i) {
            tag = datas.m_128728_(i);
            mobName = tag.m_128461_("Mob");
            list = tag.m_128437_("Datas", 10);
            list1 = new ArrayList();
            for (i1 = 0; i1 < list.size(); ++i1) {
                tag1 = list.m_128728_(i1);
                list1.add(tag1.m_128461_("Data"));
            }
            data.saveData(mobName, list1);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag tag;
        ListTag list;
        List<String> names;
        String mobName;
        ListTag animations = new ListTag();
        ListTag goals = new ListTag();
        ListTag datas = new ListTag();
        for (Map.Entry<String, List<String>> entry : this.animationMap.entrySet()) {
            mobName = entry.getKey();
            names = entry.getValue();
            list = new ListTag();
            tag = new CompoundTag();
            names.forEach(t -> {
                CompoundTag tag1 = new CompoundTag();
                tag1.m_128359_("Animation", t);
                list.add((Object)tag1);
            });
            tag.m_128359_("Mob", mobName);
            tag.m_128365_("Animations", (Tag)list);
            animations.add((Object)tag);
        }
        for (Map.Entry<String, List<String>> entry : this.goalMap.entrySet()) {
            mobName = entry.getKey();
            names = entry.getValue();
            list = new ListTag();
            tag = new CompoundTag();
            names.forEach(t -> {
                CompoundTag tag1 = new CompoundTag();
                tag1.m_128359_("Goal", t);
                list.add((Object)tag1);
            });
            tag.m_128359_("Mob", mobName);
            tag.m_128365_("Goals", (Tag)list);
            goals.add((Object)tag);
        }
        for (Map.Entry<String, List<String>> entry : this.dataMap.entrySet()) {
            mobName = entry.getKey();
            names = entry.getValue();
            list = new ListTag();
            tag = new CompoundTag();
            names.forEach(t -> {
                CompoundTag tag1 = new CompoundTag();
                tag1.m_128359_("Data", t);
                list.add((Object)tag1);
            });
            tag.m_128359_("Mob", mobName);
            tag.m_128365_("Datas", (Tag)list);
            datas.add((Object)tag);
        }
        nbt.m_128365_("MobAnimations", (Tag)animations);
        nbt.m_128365_("MobGoals", (Tag)goals);
        nbt.m_128365_("MobDatas", (Tag)datas);
        return nbt;
    }

    public List<String> getDatas(String mobName) {
        return this.dataMap.get(mobName);
    }

    public List<String> getGoals(String mobName) {
        return this.goalMap.get(mobName);
    }

    public List<String> getAnimations(String mobName) {
        return this.animationMap.get(mobName);
    }

    public void saveAnimation(String mobName, List<String> animations) {
        this.animationMap.put(mobName, animations);
        MorphNetwork.sendToAll(new UpdateMorphSuggestionsPacket("Animation", animations));
        this.m_77762_();
    }

    public void saveGoal(String mobName, List<String> goals) {
        this.goalMap.put(mobName, goals);
        MorphNetwork.sendToAll(new UpdateMorphSuggestionsPacket("Goal", goals));
        this.m_77762_();
    }

    public void saveData(String mobName, List<String> datas) {
        this.dataMap.put(mobName, datas);
        MorphNetwork.sendToAll(new UpdateMorphSuggestionsPacket("Data", datas));
        this.m_77762_();
    }
}

