/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thalassophobia.entity;

import net.mcreator.thalassophobia.init.ThalassophobiaModEntities;
import net.mcreator.thalassophobia.procedures.SunfishEntityDiesProcedure;
import net.mcreator.thalassophobia.procedures.VertebratOnEntityTickUpdateProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SunfishEntity
extends PathfinderMob
implements IAnimatable {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(SunfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SunfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(SunfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";

    public SunfishEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SunfishEntity>)((EntityType)ThalassophobiaModEntities.SUNFISH.get()), world);
    }

    public SunfishEntity(EntityType<SunfishEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
        this.m_21557_(false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (SunfishEntity.this.m_20069_()) {
                    SunfishEntity.this.m_20256_(SunfishEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !SunfishEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - SunfishEntity.this.m_20185_();
                    double dy = this.f_24976_ - SunfishEntity.this.m_20186_();
                    double dz = this.f_24977_ - SunfishEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * SunfishEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    SunfishEntity.this.m_146922_(this.m_24991_(SunfishEntity.this.m_146908_(), f, 10.0f));
                    SunfishEntity.this.f_20883_ = SunfishEntity.this.m_146908_();
                    SunfishEntity.this.f_20885_ = SunfishEntity.this.m_146908_();
                    if (SunfishEntity.this.m_20069_()) {
                        SunfishEntity.this.m_7910_((float)SunfishEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        SunfishEntity.this.m_146926_(this.m_24991_(SunfishEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(SunfishEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        SunfishEntity.this.m_21564_(f3 * f1);
                        SunfishEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        SunfishEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    SunfishEntity.this.m_7910_(0.0f);
                    SunfishEntity.this.m_21567_(0.0f);
                    SunfishEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"sunfish");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.tropical_fish.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.puffer_fish.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.puffer_fish.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19312_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        SunfishEntityDiesProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), source.m_7639_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        VertebratOnEntityTickUpdateProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.5f);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)ThalassophobiaModEntities.SUNFISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.8);
        builder = builder.m_22268_(Attributes.f_22276_, 30.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.3);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.8);
        return builder;
    }

    private <E extends IAnimatable> PlayState movementPredicate(AnimationEvent<E> event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.m_20072_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sunfish.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sunfish.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <E extends IAnimatable> PlayState procedurePredicate(AnimationEvent<E> event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation(this.animationprocedure, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
                this.animationprocedure = "empty";
                event.getController().markNeedsReload();
            }
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "movement", 4.0f, this::movementPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "procedure", 4.0f, this::procedurePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

