/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="orevolution")
public class OrevolutionConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    private static final ForgeConfigSpec COMMON_SPEC;
    private static final ForgeConfigSpec CLIENT_SPEC;

    public static void register() {
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        COMMON = (Common)commonSpecPair.getLeft();
        CLIENT = (Client)clientSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> toolsPowers;
        public final ForgeConfigSpec.ConfigValue<Boolean> weaponsPowers;
        public final ForgeConfigSpec.ConfigValue<Boolean> armorsPowers;
        public final ForgeConfigSpec.ConfigValue<Boolean> generateTinOre;
        public final ForgeConfigSpec.ConfigValue<Boolean> generatePlatOre;
        public final ForgeConfigSpec.ConfigValue<Boolean> safeOreBreaking;
        public final ForgeConfigSpec.ConfigValue<Boolean> modProgression;
        public final ForgeConfigSpec.ConfigValue<Integer> woodMaxUses;
        public final ForgeConfigSpec.ConfigValue<Integer> stoneMaxUses;
        public final ForgeConfigSpec.ConfigValue<Integer> goldMaxUses;
        public final ForgeConfigSpec.ConfigValue<Integer> ironMaxUses;
        public final ForgeConfigSpec.ConfigValue<Integer> diamondMaxUses;
        public final ForgeConfigSpec.ConfigValue<Integer> netheriteMaxUses;

        private Common(ForgeConfigSpec.Builder builder) {
            builder.push("powers");
            this.toolsPowers = builder.comment("Defines if tools will have their special characteristic (aka power), like tin's drop duplication").define("tools_powers", true);
            this.weaponsPowers = builder.comment("Defines if weapons will have their special characteristic (aka power), like tin's drop duplication").define("weapons_powers", true);
            this.armorsPowers = builder.comment("Defines if armors will have their special characteristic (aka power), like platinum's strength II effect").define("armors_powers", true);
            builder.pop();
            builder.push("gameplay_general");
            this.generateTinOre = builder.comment("Defines if tin ore will generate in your world").define("generate_tin_ore", true);
            this.generatePlatOre = builder.comment("Defines if platinum ore will generate in your world").define("generate_platinum_ore", true);
            this.safeOreBreaking = builder.comment("Ores won't break if mined with the incorrect tool").define("safe_ore_breaking", true);
            this.modProgression = builder.comment("Replaces the original ore progression of the game").define("modded_progression", true);
            builder.pop();
            builder.push("gameplay_durability");
            this.woodMaxUses = builder.comment("Modifies the max uses of wood tools and weapons. vanilla is 59").defineInRange("wood_max_uses", 64, 1, Integer.MAX_VALUE);
            this.goldMaxUses = builder.comment("Modifies the max uses of gold tools and weapons. vanilla is 32").defineInRange("gold_max_uses", 128, 1, Integer.MAX_VALUE);
            this.stoneMaxUses = builder.comment("Modifies the max uses of stone tools and weapons. vanilla is 131").defineInRange("stone_max_uses", 192, 1, Integer.MAX_VALUE);
            this.ironMaxUses = builder.comment("Modifies the max uses of iron tools and weapons. vanilla is 250").defineInRange("iron_max_uses", 448, 1, Integer.MAX_VALUE);
            this.diamondMaxUses = builder.comment("Modifies the max uses of diamond tools and weapons. vanilla is 1561").defineInRange("diamond_max_uses", 1600, 1, Integer.MAX_VALUE);
            this.netheriteMaxUses = builder.comment("Modifies the max uses of netherite tools and weapons. vanilla is 2031").defineInRange("netherite_max_uses", 2432, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> warnBreak;
        public final ForgeConfigSpec.ConfigValue<Boolean> harvestTip;
        public final ForgeConfigSpec.ConfigValue<Boolean> toolsPowersTip;
        public final ForgeConfigSpec.ConfigValue<Boolean> weaponsPowersTip;
        public final ForgeConfigSpec.ConfigValue<Boolean> armorsPowersTip;
        public final ForgeConfigSpec.ConfigValue<Boolean> tinProgTip;
        public final ForgeConfigSpec.ConfigValue<Boolean> platProgTip;

        private Client(ForgeConfigSpec.Builder builder) {
            builder.push("gameplay");
            this.warnBreak = builder.comment("Display the text 'You can't harvest this block yet!'").define("warn_break", true);
            builder.pop();
            builder.push("tooltips");
            this.harvestTip = builder.comment("Display the 'Harvest tier' tooltip on all tiered tools").define("harvest_tip", true);
            this.toolsPowersTip = builder.comment("Display the 'power' tooltip on all tools that have one").define("tools_powers_tip", true);
            this.weaponsPowersTip = builder.comment("Display the 'power' tooltip on all weapons that have one").define("weapons_powers_tip", true);
            this.armorsPowersTip = builder.comment("Display the 'power' tooltip on all armors that have one").define("armors_powers_tip", true);
            this.tinProgTip = builder.comment("Display the 'Tin tier' tooltip on all stone-tiered tools").define("tin_prog_tip", true);
            this.platProgTip = builder.comment("Display the 'Platinum tier' tooltip on all iron-tiered tools").define("plat_prog_tip", true);
            builder.pop();
        }
    }
}

