/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.armors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bexla.orevolution.content.types.OrevolutionArmorPower;
import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ArmorCauseEffectsOnAttacked
extends OrevolutionArmorPower {
    private final List<Supplier<MobEffect>> effectsWearer;
    private final List<Supplier<MobEffect>> effectsAttacker;
    private final int duration;
    private final int amplifier;
    private final String tooltip_wearer_id;

    public ArmorCauseEffectsOnAttacked(String tooltip_target_id, String tooltip_wearer_id, Conditional conditional, int duration, int amplifier, List<Supplier<MobEffect>> effectsWearer, List<Supplier<MobEffect>> effectsAttacker) {
        super(tooltip_target_id, conditional);
        this.effectsWearer = effectsWearer;
        this.effectsAttacker = effectsAttacker;
        this.duration = duration;
        this.amplifier = amplifier;
        this.tooltip_wearer_id = tooltip_wearer_id;
    }

    public ArmorCauseEffectsOnAttacked(String tooltip_target_id, String tooltip_wearer_id, Conditional conditional, int duration, int amplifier, Supplier<MobEffect> effectWearer, Supplier<MobEffect> effectAttacker) {
        super(tooltip_target_id, conditional);
        this.effectsWearer = effectWearer != null ? List.of(effectWearer) : null;
        this.effectsAttacker = effectAttacker != null ? List.of(effectAttacker) : null;
        this.duration = duration;
        this.amplifier = amplifier;
        this.tooltip_wearer_id = tooltip_wearer_id;
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        ArrayList<Component> tips = new ArrayList<Component>();
        if (this.effectsAttacker != null) {
            tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.getTooltipID())).m_130940_(ChatFormatting.GREEN));
            for (Supplier<MobEffect> p : this.effectsAttacker) {
                tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString() + (String)(this.amplifier > 0 ? " " + Component.m_237115_((String)("potion.potency." + this.amplifier)).getString() : ""))).m_130940_(ChatFormatting.AQUA));
            }
        }
        if (this.effectsWearer != null) {
            tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.tooltip_wearer_id)).m_130940_(ChatFormatting.GREEN));
            for (Supplier<MobEffect> p : this.effectsWearer) {
                tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString() + (String)(this.amplifier > 0 ? " " + Component.m_237115_((String)("potion.potency." + this.amplifier)).getString() : ""))).m_130940_(ChatFormatting.AQUA));
            }
        }
        return tips;
    }

    @Override
    public void onAttacked(LivingEntity wearer, DamageSource source, float amount) {
        LivingEntity attacker = (LivingEntity)source.m_7639_();
        if (!this.getCondition(null, wearer.m_9236_(), wearer, attacker)) {
            return;
        }
        if (this.effectsWearer != null) {
            for (Supplier<MobEffect> p : this.effectsWearer) {
                if (wearer.m_21023_(p.get())) {
                    wearer.m_21124_(p.get()).m_19558_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
                    continue;
                }
                wearer.m_7292_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
            }
        }
        if (this.effectsAttacker != null) {
            for (Supplier<MobEffect> p : this.effectsAttacker) {
                if (attacker.m_21023_(p.get())) {
                    attacker.m_21124_(p.get()).m_19558_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
                    continue;
                }
                attacker.m_7292_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
            }
        }
    }
}

