/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.types;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.bexla.orevolution.content.types.interfaces.ToolPower;
import net.minecraft.world.item.Tier;
import org.slf4j.Logger;

public class ToolPowerRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Tier, ToolPowerPair> tierTagMap = new HashMap<Tier, ToolPowerPair>();

    public static void registerTier(Tier tier, ToolPower toolPower, ToolPower swordPower) {
        if (tierTagMap.containsKey(tier)) {
            LOGGER.warn("Overriding existing ToolPower registration for tier: {}", (Object)tier);
        }
        tierTagMap.put(tier, new ToolPowerPair(toolPower, swordPower));
        LOGGER.debug("Registered powers for tier {} -> Tool: {}, Sword: {}", new Object[]{tier, toolPower.getClass().getSimpleName(), swordPower.getClass().getSimpleName()});
    }

    public static ToolPower getToolPowerForTier(Tier tier) {
        ToolPowerPair pair = tierTagMap.get(tier);
        return pair != null ? pair.toolPower() : ToolPower.EMPTY;
    }

    public static ToolPower getSwordPowerForTier(Tier tier) {
        ToolPowerPair pair = tierTagMap.get(tier);
        return pair != null ? pair.swordPower() : ToolPower.EMPTY;
    }

    public record ToolPowerPair(ToolPower toolPower, ToolPower swordPower) {
    }
}

