/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.events;

import net.bexla.orevolution.OrevolutionConfig;
import net.bexla.orevolution.content.types.TierProgressRegistry;
import net.bexla.orevolution.content.types.ToolPowerRegistry;
import net.bexla.orevolution.content.types.interfaces.ToolPower;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerSubscriber {
    private static final Component CANT_HARVEST_ORE = Component.m_237115_((String)"actionbar.orevolution.cant_harvest_ore");

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        Player player = event.getEntity();
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        Item item = player.m_21205_().m_41720_();
        if (!(item instanceof TieredItem)) {
            return;
        }
        TieredItem tiered = (TieredItem)item;
        BlockState state = event.getTargetBlock();
        Tier tier = tiered.m_43314_();
        boolean isCorrectTier = TierProgressRegistry.isCorrectTierForDrops(tier, state);
        PlayerSubscriber.showCantHarvestWarning(player, isCorrectTier, state, (Item)tiered);
        if (((Boolean)OrevolutionConfig.COMMON.modProgression.get()).booleanValue()) {
            event.setCanHarvest(isCorrectTier);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        float originalSpeed;
        Player player = event.getEntity();
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof TieredItem)) {
            return;
        }
        TieredItem tiered = (TieredItem)item;
        BlockState state = event.getState();
        Tier tier = tiered.m_43314_();
        boolean isCorrectTier = TierProgressRegistry.isCorrectTierForDrops(tier, state);
        PlayerSubscriber.showCantHarvestWarning(player, isCorrectTier, state, (Item)tiered);
        float newSpeed = originalSpeed = event.getOriginalSpeed();
        if (tiered instanceof SwordItem && ((Boolean)OrevolutionConfig.COMMON.weaponsPowers.get()).booleanValue()) {
            ToolPower power = ToolPowerRegistry.getSwordPowerForTier(tier);
            newSpeed = power.setDestroySpeed(stack, state, originalSpeed);
        } else if (tiered instanceof DiggerItem && ((Boolean)OrevolutionConfig.COMMON.toolsPowers.get()).booleanValue()) {
            ToolPower power = ToolPowerRegistry.getToolPowerForTier(tier);
            newSpeed = power.setDestroySpeed(stack, state, originalSpeed);
        }
        if (((Boolean)OrevolutionConfig.COMMON.safeOreBreaking.get()).booleanValue() && !TierProgressRegistry.isCorrectTierForDrops(tier, state) && state.m_204336_(Tags.Blocks.ORES)) {
            newSpeed = 0.0f;
        }
        if (newSpeed != originalSpeed) {
            event.setNewSpeed(newSpeed);
        }
    }

    private static void showCantHarvestWarning(Player player, boolean isCorrectTier, BlockState state, Item item) {
        if (((Boolean)OrevolutionConfig.CLIENT.warnBreak.get()).booleanValue() && !isCorrectTier && PlayerSubscriber.isToolCorrectForBlock(item, state)) {
            player.m_5661_(CANT_HARVEST_ORE, true);
        }
    }

    private static boolean isToolCorrectForBlock(Item item, BlockState state) {
        return state.m_204336_(BlockTags.f_144282_) && item instanceof PickaxeItem || state.m_204336_(BlockTags.f_144283_) && item instanceof ShovelItem || state.m_204336_(BlockTags.f_144280_) && item instanceof AxeItem || state.m_204336_(BlockTags.f_144281_) && item instanceof HoeItem || state.m_204336_(BlockTags.f_278398_) && item instanceof SwordItem;
    }
}

