/*
 * Decompiled with CFR 0.152.
 */
package cn.mlus.bettervannilafishes.block;

import cn.mlus.bettervannilafishes.block.be.FishSpecimenBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FishSpecimen
extends BaseEntityBlock
implements GeoBlockEntity {
    public static final IntegerProperty HANGING = IntegerProperty.m_61631_((String)"hanging", (int)0, (int)2);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape HANGING_AABB = Block.m_49796_((double)0.0, (double)-26.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public FishSpecimen(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        int hangingState = (Integer)state.m_61143_((Property)HANGING);
        return switch (hangingState) {
            case 0 -> Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
            case 1 -> {
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                yield Block.m_49863_((LevelReader)level, (BlockPos)pos.m_121945_(facing.m_122424_()), (Direction)facing);
            }
            case 2 -> Block.m_49863_((LevelReader)level, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN);
            default -> false;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing;
        int hangingState;
        Direction clickedFace = context.m_43719_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (clickedFace == Direction.DOWN) {
            hangingState = 2;
            facing = context.m_8125_();
        } else if (clickedFace == Direction.UP) {
            hangingState = 0;
            facing = context.m_8125_();
        } else {
            hangingState = 1;
            facing = clickedFace;
        }
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Integer.valueOf(hangingState))).m_61124_((Property)FACING, (Comparable)facing);
        if (blockstate.m_60710_((LevelReader)level, pos)) {
            return blockstate;
        }
        if (hangingState != 0 && (blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_60710_((LevelReader)level, pos)) {
            return blockstate;
        }
        if (hangingState != 1) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)direction);
                if (!blockstate.m_60710_((LevelReader)level, pos)) continue;
                return blockstate;
            }
        }
        if (hangingState != 2 && (blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Integer.valueOf(2))).m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_60710_((LevelReader)level, pos)) {
            return blockstate;
        }
        return null;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FishSpecimenBlockEntity) {
            FishSpecimenBlockEntity fishEntity = (FishSpecimenBlockEntity)blockEntity;
            if (stack.m_41782_() && stack.m_41783_().m_128441_("Scale")) {
                float scale = stack.m_41783_().m_128457_("Scale");
                fishEntity.setScale(scale);
            } else {
                fishEntity.setScale(1.0f);
            }
        }
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FishSpecimenBlockEntity) {
                FishSpecimenBlockEntity entity = (FishSpecimenBlockEntity)tileEntity;
                ItemStack drop = new ItemStack((ItemLike)state.m_60734_());
                drop.m_41784_().m_128350_("Scale", entity.getScale());
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), drop));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.m_61143_((Property)HANGING) == 2 ? HANGING_AABB : AABB;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HANGING, FACING});
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new FishSpecimenBlockEntity(blockPos, blockState);
    }
}

