/*
 * Decompiled with CFR 0.152.
 */
package cn.mlus.bettervannilafishes.client.animator;

import cn.mlus.bettervannilafishes.client.animator.CircularBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class GeneralAnimator<T extends Mob> {
    protected final CircularBuffer yawTrail = new CircularBuffer(64);
    protected final CircularBuffer pitchTrail = new CircularBuffer(16);
    private final CircularBuffer yTrail = new CircularBuffer(8);
    protected T entity;
    protected float partialTicks;
    private boolean init;

    public GeneralAnimator(T entity) {
        this.entity = entity;
        this.init = false;
    }

    public void tick() {
        if (!this.init) {
            this.init = true;
            this.yawTrail.fill(-((Mob)this.entity).f_20883_);
            this.yTrail.fill((float)this.entity.m_20186_());
            this.pitchTrail.fill(this.getModelPitch(this.partialTicks));
        }
        this.yawTrail.update(-((Mob)this.entity).f_20883_);
        this.yTrail.update((float)this.entity.m_20186_());
        this.pitchTrail.update(this.getModelPitch(this.partialTicks));
    }

    public void animate(GeoModel<T> model, AnimationState<T> animationState) {
    }

    public float getModelPitch(float pt, float amp) {
        float pitchMovingMax = 90.0f;
        return Mth.m_14036_((float)(this.yTrail.get(pt, 5, 0) * amp), (float)(-pitchMovingMax), (float)pitchMovingMax);
    }

    public float getModelPitch(float pt) {
        return this.getModelPitch(pt, 10.0f);
    }

    public List<GeoBone> getBonesByName(String[] boneNames, GeoModel<T> model) {
        ArrayList<GeoBone> bones = new ArrayList<GeoBone>();
        for (String boneName : boneNames) {
            Optional bone = model.getBone(boneName);
            bone.ifPresent(bones::add);
        }
        return bones;
    }

    public void setPartialTick(float partialTicks) {
        this.partialTicks = partialTicks;
    }
}

