/*
 * Decompiled with CFR 0.152.
 */
package cn.mlus.bettervannilafishes.data;

import cn.mlus.bettervannilafishes.BetterVannilaFishes;
import cn.mlus.bettervannilafishes.init.BvcEntities;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class BvcBiomeModifier {
    public static void register(BootstapContext<BiomeModifier> context) {
        BvcBiomeModifier.removeSpawn(context, "cod_ocean", (TagKey<Biome>)BiomeTags.f_207603_, EntityType.f_20556_);
        BvcBiomeModifier.removeSpawn(context, "salmon_ocean", (TagKey<Biome>)BiomeTags.f_207603_, EntityType.f_20519_);
        BvcBiomeModifier.removeSpawn(context, "pufferfish_ocean", (TagKey<Biome>)BiomeTags.f_207603_, EntityType.f_20516_);
        BvcBiomeModifier.removeSpawn(context, "cod_river", (TagKey<Biome>)BiomeTags.f_207605_, EntityType.f_20556_);
        BvcBiomeModifier.removeSpawn(context, "salmon_river", (TagKey<Biome>)BiomeTags.f_207605_, EntityType.f_20519_);
        BvcBiomeModifier.addSpawn(context, "haddock_cod", (TagKey<Biome>)BiomeTags.f_207603_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.BVC_HADDOCK_COD.get(), 12, 3, 9));
        BvcBiomeModifier.addSpawn(context, "atlantic_cod", (TagKey<Biome>)BiomeTags.f_207603_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.BVC_ATLANTIC_COD.get(), 10, 3, 9));
        BvcBiomeModifier.addSpawn(context, "pacific_cod", (TagKey<Biome>)BiomeTags.f_207603_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.BVC_PACIFIC_COD.get(), 12, 3, 9));
        BvcBiomeModifier.addSpawn(context, "male_salmon", (TagKey<Biome>)BiomeTags.f_207605_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.BVC_SALMON_MALE.get(), 12, 2, 6));
        BvcBiomeModifier.addSpawn(context, "female_salmon", (TagKey<Biome>)BiomeTags.f_207605_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.BVC_SALMON_FEMALE.get(), 12, 2, 6));
        BvcBiomeModifier.addSpawn(context, "atlantic_salmon", (TagKey<Biome>)BiomeTags.f_207603_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.BVC_SALMON_PACIFIC.get(), 12, 3, 9));
        BvcBiomeModifier.addSpawn(context, "yellow_fin_puffer", (TagKey<Biome>)BiomeTags.f_207603_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.YELLOW_FIN_PUFFER.get(), 7, 1, 1));
        BvcBiomeModifier.addSpawn(context, "obscure_puffer_ocean", (TagKey<Biome>)BiomeTags.f_207603_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.OBSCURE_PUFFER.get(), 7, 1, 1));
        BvcBiomeModifier.addSpawn(context, "obscure_puffer_river", (TagKey<Biome>)BiomeTags.f_207605_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.OBSCURE_PUFFER.get(), 8, 3, 4));
        BvcBiomeModifier.addSpawn(context, "nautilus", (TagKey<Biome>)BiomeTags.f_207603_, new MobSpawnSettings.SpawnerData((EntityType)BvcEntities.NAUTILUS.get(), 6, 1, 1));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        BvcBiomeModifier.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, MobSpawnSettings.SpawnerData ... spawns) {
        BvcBiomeModifier.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}), List.of(spawns)));
    }

    private static void removeSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, EntityType<?> ... types) {
        BvcBiomeModifier.register(context, "remove_spawn/" + name, () -> new ForgeBiomeModifiers.RemoveSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), (HolderSet)HolderSet.m_205800_(Stream.of(types).map(type -> (Holder)ForgeRegistries.ENTITY_TYPES.getHolder(type).get()).collect(Collectors.toList()))));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)BetterVannilaFishes.prefix(name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        BvcBiomeModifier.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), BvcBiomeModifier.featureSet(context, features), step));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }
}

