/*
 * Decompiled with CFR 0.152.
 */
package cn.mlus.bettervannilafishes.entity.nautilus;

import cn.mlus.bettervannilafishes.client.animator.BvcNautilusAnimator;
import cn.mlus.bettervannilafishes.client.animator.GeneralAnimator;
import cn.mlus.bettervannilafishes.entity.BvcEntity;
import cn.mlus.bettervannilafishes.entity.GeneralBodyControl;
import cn.mlus.bettervannilafishes.entity.ai.BvcFollowOwnerGoal;
import cn.mlus.bettervannilafishes.init.BvcItems;
import cn.mlus.bettervannilafishes.init.BvcMobEffects;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NautilusEntity
extends TamableAnimal
implements GeoEntity,
BvcEntity<NautilusEntity>,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FEEDING_TICK = SynchedEntityData.m_135353_(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHELTER_TICK = SynchedEntityData.m_135353_(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(NautilusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final GeneralAnimator<NautilusEntity> animator = new BvcNautilusAnimator(this);
    private static final Predicate<LivingEntity> SCARY_MOB = p_289442_ -> {
        if (p_289442_ instanceof Player) {
            Player player = (Player)p_289442_;
            return !player.m_7500_() && !player.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42528_);
        }
        return p_289442_.m_6336_() != MobType.f_21644_;
    };
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(SCARY_MOB);
    public TemptGoal temptGoal;

    public NautilusEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GeneralBodyControl((Mob)this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(FEEDING_TICK, (Object)0);
        this.f_19804_.m_135372_(SHELTER_TICK, (Object)0);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public int getFeedingTick() {
        return (Integer)this.f_19804_.m_135370_(FEEDING_TICK);
    }

    public void setFeedingTick(int tick) {
        this.f_19804_.m_135381_(FEEDING_TICK, (Object)tick);
    }

    public int getShelterTick() {
        return (Integer)this.f_19804_.m_135370_(SHELTER_TICK);
    }

    public void setShelterTick(int tick) {
        this.f_19804_.m_135381_(SHELTER_TICK, (Object)tick);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void m_6872_(ItemStack pStack) {
        this.m_7380_(pStack.m_41784_());
    }

    public void m_142278_(@NotNull CompoundTag pTag) {
        this.m_7378_(pTag);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
        pCompound.m_128405_("Command", this.getCommand());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
        this.setCommand(pCompound.m_128451_("Command"));
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)BvcItems.NAUTILUS_BUCKET.get());
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.animator.tick();
        } else {
            if (this.temptGoal != null && this.temptGoal.m_25955_()) {
                this.setFeedingTick(this.getFeedingTick() + 1);
            } else {
                this.setFeedingTick(Math.max(0, this.getFeedingTick() - 1));
            }
            if (this.getShelterTick() > 0) {
                this.f_21344_.m_26573_();
                this.setShelterTick(this.getShelterTick() - 1);
            }
            if (this.m_21824_() && this.f_19797_ % 100 == 0) {
                List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(8.0), entity -> entity instanceof Player);
                entities.forEach(entity -> {
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.m_7292_(new MobEffectInstance((MobEffect)BvcMobEffects.NAUTILUS_BLESSING.get(), 200, 0, false, false, true));
                    }
                });
            }
            if (this.f_19797_ % 400 == 0) {
                this.m_5634_(1.0f);
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 10, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.getFeedingTick() > 0) {
                if (state.isMoving()) {
                    builder.thenLoop("animation.swimming_feeding");
                } else {
                    builder.thenLoop("animation.idle_feeding");
                }
            } else if (state.isMoving()) {
                builder.thenLoop("animation.swimming");
            } else {
                builder.thenLoop("animation.idle");
            }
            return state.setAndContinue(builder);
        });
        AnimationController control = new AnimationController((GeoAnimatable)this, "control", 0, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.getShelterTick() > 0) {
                builder.thenPlayAndHold("animation.shelter");
            } else {
                builder.thenPlay("animation.shelter_out");
            }
            return state.setAndContinue(builder);
        });
        controllerRegistrar.add(new AnimationController[]{main, control});
    }

    protected void m_8099_() {
        this.temptGoal = new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_}), false);
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 0.0){

            public void m_8056_() {
                super.m_8056_();
                NautilusEntity.this.setShelterTick(1200);
                NautilusEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 1200, 5, false, false, true));
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new ShelterGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new BvcFollowOwnerGoal(this, 6.0f, 3.0f, false){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && NautilusEntity.this.getShelterTick() == 0 && NautilusEntity.this.getCommand() == 0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40){

            public boolean m_8036_() {
                return super.m_8036_() && NautilusEntity.this.getShelterTick() == 0;
            }
        });
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand pHand) {
        if (player.m_21205_().m_41720_() == Items.f_42447_ && (!this.m_21824_() || this.m_21830_((LivingEntity)player))) {
            return Bucketable.m_148828_((Player)player, (InteractionHand)pHand, (LivingEntity)this).orElse(InteractionResult.PASS);
        }
        if (!this.m_9236_().m_5776_() && this.m_6898_(player.m_21205_()) && this.getShelterTick() == 0) {
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
        }
        if (pHand == InteractionHand.MAIN_HAND && this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.m_6898_(player.m_21205_())) {
            if (!this.m_9236_().m_5776_()) {
                this.setCommand(this.getCommand() + 1);
                if (this.getCommand() == 2) {
                    this.setCommand(0);
                }
            }
            String commandText = "follow";
            if (this.getCommand() == 1) {
                commandText = "hanging";
            }
            player.m_5661_((Component)Component.m_237115_((String)("bvc.command." + commandText)), true);
        }
        return super.m_6071_(player, pHand);
    }

    public boolean m_6898_(@NotNull ItemStack pStack) {
        return pStack.m_150930_(Items.f_42528_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public GeneralAnimator<NautilusEntity> getAnimator() {
        return this.animator;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        return null;
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    private class ShelterGoal
    extends Goal {
        private final NautilusEntity fish;

        public ShelterGoal(NautilusEntity pFish) {
            this.fish = pFish;
        }

        public boolean m_8036_() {
            Object e;
            List $$0 = this.fish.m_9236_().m_6443_(LivingEntity.class, this.fish.m_20191_().m_82400_(2.0), p_149015_ -> targetingConditions.m_26885_((LivingEntity)this.fish, p_149015_));
            if ($$0.size() == 1 && (e = $$0.get(0)) instanceof Player) {
                Player player = (Player)e;
                return !this.fish.m_21830_((LivingEntity)player);
            }
            return !$$0.isEmpty();
        }

        public void m_8056_() {
            NautilusEntity.this.setShelterTick(1200);
            this.fish.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 1200, 5, false, false, true));
        }
    }
}

