/*
 * Decompiled with CFR 0.152.
 */
package cn.mlus.bettervannilafishes.entity.pufferfish;

import cn.mlus.bettervannilafishes.client.animator.BvcPufferfishAnimator;
import cn.mlus.bettervannilafishes.client.animator.GeneralAnimator;
import cn.mlus.bettervannilafishes.entity.BvcEntity;
import cn.mlus.bettervannilafishes.entity.GeneralBodyControl;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class BvcPufferfishEntity
extends AbstractFish
implements GeoEntity,
BvcEntity<BvcPufferfishEntity> {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> PUFF_STATE = SynchedEntityData.m_135353_(BvcPufferfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    int inflateCounter;
    int deflateTimer;
    private static final Predicate<LivingEntity> SCARY_MOB = p_289442_ -> {
        if (p_289442_ instanceof Player && ((Player)p_289442_).m_7500_()) {
            return false;
        }
        return p_289442_.m_6095_() == EntityType.f_147039_ || p_289442_.m_6336_() != MobType.f_21644_;
    };
    static final TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(SCARY_MOB);
    GeneralAnimator<BvcPufferfishEntity> animator;

    public BvcPufferfishEntity(EntityType<? extends AbstractFish> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_6210_();
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.animator = new BvcPufferfishAnimator(this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 20, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.m_20069_()) {
                if (state.isMoving()) {
                    if (this.getPuffState() == 0) {
                        builder.thenLoop("animation.swim");
                    } else {
                        builder.thenLoop("animation.swell_swim");
                    }
                } else if (this.getPuffState() == 0) {
                    builder.thenLoop("animation.idle");
                } else {
                    builder.thenLoop("animation.swell_idle");
                }
            } else {
                builder.thenLoop("animation.flop");
            }
            return state.setAndContinue(builder);
        });
        AnimationController control = new AnimationController((GeoAnimatable)this, "control", 0, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.getPuffState() != 0) {
                builder.thenPlay("animation.swell");
            } else {
                builder.thenPlay("animation.deflate");
            }
            return state.setAndContinue(builder);
        });
        controllerRegistrar.add(new AnimationController[]{main, control});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GeneralBodyControl((Mob)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PUFF_STATE, (Object)0);
    }

    public int getPuffState() {
        return (Integer)this.f_19804_.m_135370_(PUFF_STATE);
    }

    public void setPuffState(int pPuffState) {
        this.f_19804_.m_135381_(PUFF_STATE, (Object)pPuffState);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        if (PUFF_STATE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_27495_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.45).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("PuffState", this.getPuffState());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setPuffState(Math.min(pCompound.m_128451_("PuffState"), 2));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PufferfishPuffGoal(this));
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_21515_()) {
            if (this.inflateCounter > 0) {
                if (this.getPuffState() == 0) {
                    this.m_5496_(SoundEvents.f_12291_, this.m_6121_(), this.m_6100_());
                    this.setPuffState(1);
                } else if (this.inflateCounter > 40 && this.getPuffState() == 1) {
                    this.setPuffState(2);
                }
                ++this.inflateCounter;
            } else if (this.getPuffState() != 0) {
                if (this.deflateTimer > 60 && this.getPuffState() == 2) {
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && this.getPuffState() == 1) {
                    this.m_5496_(SoundEvents.f_12290_, this.m_6121_(), this.m_6100_());
                    this.setPuffState(0);
                }
                ++this.deflateTimer;
            }
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.getAnimator().tick();
        }
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12289_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12292_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12294_;
    }

    @NotNull
    protected SoundEvent m_5699_() {
        return SoundEvents.f_12293_;
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        return super.m_6972_(pPose).m_20388_(BvcPufferfishEntity.getScale(this.getPuffState()));
    }

    private static float getScale(int pPuffState) {
        return pPuffState == 0 ? 0.5f : 0.65f;
    }

    public int m_5792_() {
        return 2;
    }

    @Override
    public GeneralAnimator<BvcPufferfishEntity> getAnimator() {
        return this.animator;
    }

    private static class PufferfishPuffGoal
    extends Goal {
        private final BvcPufferfishEntity fish;

        public PufferfishPuffGoal(BvcPufferfishEntity pFish) {
            this.fish = pFish;
        }

        public boolean m_8036_() {
            List $$0 = this.fish.m_9236_().m_6443_(LivingEntity.class, this.fish.m_20191_().m_82400_(2.0), p_149015_ -> targetingConditions.m_26885_((LivingEntity)this.fish, p_149015_));
            return !$$0.isEmpty();
        }

        public void m_8056_() {
            this.fish.inflateCounter = 1;
            this.fish.deflateTimer = 0;
        }

        public void m_8041_() {
            this.fish.inflateCounter = 0;
        }
    }
}

