/*
 * Decompiled with CFR 0.152.
 */
package cn.mlus.bettervannilafishes.event;

import cn.mlus.bettervannilafishes.entity.BvcAbstractFish;
import cn.mlus.bettervannilafishes.entity.nautilus.NautilusEntity;
import cn.mlus.bettervannilafishes.entity.pufferfish.BvcPufferfishEntity;
import cn.mlus.bettervannilafishes.init.BvcEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="bettervannilafishes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EntityAttributeHandler {
    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)BvcEntities.BVC_HADDOCK_COD.get(), BvcAbstractFish.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.BVC_ATLANTIC_COD.get(), BvcAbstractFish.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.BVC_PACIFIC_COD.get(), BvcAbstractFish.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.BVC_SALMON_MALE.get(), BvcAbstractFish.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.BVC_SALMON_FEMALE.get(), BvcAbstractFish.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.BVC_SALMON_PACIFIC.get(), BvcAbstractFish.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.YELLOW_FIN_PUFFER.get(), BvcPufferfishEntity.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.OBSCURE_PUFFER.get(), BvcPufferfishEntity.m_27495_().m_22265_());
        event.put((EntityType)BvcEntities.NAUTILUS.get(), NautilusEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)BvcEntities.BVC_HADDOCK_COD.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCodSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.BVC_ATLANTIC_COD.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCodSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.BVC_PACIFIC_COD.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCodSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.BVC_SALMON_MALE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCustomWaterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.BVC_SALMON_FEMALE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCustomWaterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.BVC_SALMON_PACIFIC.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkCustomWaterSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.YELLOW_FIN_PUFFER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkPufferSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.OBSCURE_PUFFER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkPufferSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)BvcEntities.NAUTILUS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityAttributeHandler::checkPufferSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static boolean checkCodSpawnRules(EntityType<? extends WaterAnimal> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (level.m_204166_(pos).m_203565_(Biomes.f_48166_) || level.m_204166_(pos).m_203565_(Biomes.f_48167_) || level.m_204166_(pos).m_203565_(Biomes.f_48170_)) {
            return false;
        }
        return WaterAnimal.m_218282_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean checkPufferSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!(level.m_204166_(pos).m_203565_(Biomes.f_48166_) || level.m_204166_(pos).m_203565_(Biomes.f_48167_) || level.m_204166_(pos).m_203565_(Biomes.f_48170_) || level.m_204166_(pos).m_203565_(Biomes.f_48208_))) {
            return false;
        }
        return EntityAttributeHandler.checkSurfaceWaterAnimalSpawnRules(level, pos);
    }

    public static boolean checkCustomWaterSpawnRules(EntityType<? extends WaterAnimal> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (EntityAttributeHandler.rollSpawn(3, random, spawnType)) {
            return EntityAttributeHandler.checkSurfaceWaterAnimalSpawnRules(level, pos);
        }
        return false;
    }

    public static boolean checkSurfaceWaterAnimalSpawnRules(LevelAccessor pLevel, BlockPos pPos) {
        int $$5 = pLevel.m_5736_();
        int $$6 = $$5 - 13;
        return pPos.m_123342_() >= $$6 && pPos.m_123342_() <= $$5 && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public static boolean rollSpawn(int rolls, RandomSource random, MobSpawnType reason) {
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        return rolls <= 0 || random.m_188503_(rolls) == 0;
    }
}

