/*
 * Decompiled with CFR 0.152.
 */
package cn.mlus.bettervannilafishes.item;

import javax.annotation.Nullable;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class EnchantedPuffer
extends BowItem {
    private int clientSideAttackTime;
    @Nullable
    private LivingEntity clientSideCachedAttackTarget;

    public EnchantedPuffer(Item.Properties pProperties) {
        super(pProperties.m_41499_(50));
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public int getAttackDuration() {
        return 80;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        double range = 10.0;
        LivingEntity closestTarget = null;
        double closestDistance = Double.MAX_VALUE;
        for (LivingEntity entity : pPlayer.m_9236_().m_45976_(LivingEntity.class, pPlayer.m_20191_().m_82400_(range))) {
            double distance;
            if (entity == pPlayer || !entity.m_6336_().equals(MobType.f_21641_) && !(entity instanceof Guardian) || !((distance = pPlayer.m_20280_((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestTarget = entity;
        }
        if (closestTarget != null) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = closestTarget;
        }
        if (this.clientSideCachedAttackTarget == null || !this.clientSideCachedAttackTarget.m_6084_()) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(@NotNull Level pLevel, @NotNull LivingEntity livingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        LivingEntity target;
        if (this.clientSideAttackTime < this.getAttackDuration()) {
            ++this.clientSideAttackTime;
        }
        if ((target = this.clientSideCachedAttackTarget) != null) {
            float yawRad = livingEntity.m_146908_() * ((float)Math.PI / 180);
            double rightHandOffsetX = -Math.sin(yawRad) * 0.4;
            double rightHandOffsetZ = Math.cos(yawRad) * 0.4;
            double rightHandOffsetY = -0.25;
            double rightHandX = livingEntity.m_20185_() + rightHandOffsetX;
            double rightHandY = livingEntity.m_20188_() + rightHandOffsetY;
            double rightHandZ = livingEntity.m_20189_() + rightHandOffsetZ;
            double dx = target.m_20185_() - rightHandX;
            double dy = target.m_20227_(0.5) - rightHandY;
            double dz = target.m_20189_() - rightHandZ;
            double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
            dx /= distance;
            dy /= distance;
            dz /= distance;
            for (int i = 0; i < 5; ++i) {
                double offsetX = (pLevel.f_46441_.m_188500_() - 0.5) * 0.3;
                double offsetY = (pLevel.f_46441_.m_188500_() - 0.5) * 0.3;
                double offsetZ = (pLevel.f_46441_.m_188500_() - 0.5) * 0.3;
                double beamProgress = pLevel.f_46441_.m_188500_() * distance;
                pLevel.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 1.0f, 0.4f), 1.0f), rightHandX + dx * beamProgress + offsetX, rightHandY + dy * beamProgress + offsetY, rightHandZ + dz * beamProgress + offsetZ, 0.0, 0.0, 0.0);
            }
            pLevel.m_6263_(null, rightHandX, rightHandY, rightHandZ, SoundEvents.f_11736_, SoundSource.PLAYERS, 0.7f, 1.5f + pLevel.f_46441_.m_188501_() * 0.3f);
            if (pLevel.f_46441_.m_188501_() < 0.2f) {
                pLevel.m_6263_(null, rightHandX, rightHandY, rightHandZ, SoundEvents.f_11737_, SoundSource.PLAYERS, 0.3f, 2.0f);
            }
        }
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            int i = this.m_8105_(pStack) - pTimeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)i, (boolean)true)) < 0) {
                return;
            }
            float f = EnchantedPuffer.m_40661_((int)i);
            if (!((double)f < 0.1)) {
                if (!pLevel.f_46443_) {
                    pStack.m_41622_(1, (LivingEntity)player, p_289501_ -> p_289501_.m_21190_(player.m_7655_()));
                    if (this.clientSideCachedAttackTarget != null) {
                        this.clientSideCachedAttackTarget.m_6469_(pLevel.m_269111_().m_269425_(), 20.0f * f);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }
}

