/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.deadlydiamond98.way.Way;
import net.deadlydiamond98.way.client.WayKeybindings;
import net.deadlydiamond98.way.common.events.WayTickingEvent;
import net.deadlydiamond98.way.util.ColorUtil;
import net.deadlydiamond98.way.util.FaceRenderingUtil;
import net.deadlydiamond98.way.util.PlayerLocation;
import net.deadlydiamond98.way.util.mixin.IGlowingWayPlayer;
import net.deadlydiamond98.way.util.mixin.IWayPlayer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WayNameplateRenderer {
    private static final ResourceLocation FIX_RENDERING_THING = new ResourceLocation("way", "textures/plz_work.png");
    private static final float[] UV = new float[]{0.125f, 0.25f};
    private static final int NAMETAG_RENDER_CUTTOFF = 100;

    public static void render(PoseStack poseStack, MultiBufferSource bufferSource, ClientLevel level, float renderTick) {
        if (WayKeybindings.renderNameOverlay()) {
            Minecraft client = Minecraft.m_91087_();
            LocalPlayer user = client.f_91074_;
            if (user instanceof IWayPlayer) {
                IWayPlayer wayPlayer = (IWayPlayer)user;
                level.m_6907_().forEach(player -> ((IGlowingWayPlayer)player).way$setGlowRendering(false));
                new ArrayList<PlayerLocation>(WayTickingEvent.PLAYER_POS).forEach(playerData -> {
                    if (playerData.getEyePosition().m_82554_(user.m_20299_(renderTick)) > 100.0) {
                        Vec3 pos = playerData.getPosition().m_82520_(0.0, (double)playerData.nametagY, 0.0);
                        WayNameplateRenderer.renderNameplate(poseStack, bufferSource, level, renderTick, wayPlayer, playerData, pos, null);
                    } else {
                        level.m_6907_().forEach(player -> {
                            boolean thirdPerson = user.equals(player) && !client.m_91290_().f_114358_.m_90594_();
                            boolean invis = player.m_20163_() || player.m_20145_();
                            boolean isSame = playerData.name.getString().equals(player.m_7755_().getString());
                            if (isSame && !thirdPerson && !invis && player.m_20270_((Entity)user) <= 100.0f) {
                                Vec3 pos = player.m_20318_(renderTick).m_82520_(0.0, (double)player.m_278726_(), 0.0);
                                WayNameplateRenderer.renderNameplate(poseStack, bufferSource, level, renderTick, wayPlayer, playerData, pos, (Player)player);
                                if (((IWayPlayer)user).way$canSeeOutline()) {
                                    ((IGlowingWayPlayer)player).way$setOutlineColor(playerData.hex);
                                    ((IGlowingWayPlayer)player).way$setGlowRendering(true);
                                } else {
                                    ((IGlowingWayPlayer)player).way$setGlowRendering(false);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private static void renderNameplate(PoseStack poseStack, MultiBufferSource bufferSource, ClientLevel level, float renderTick, IWayPlayer viewer, PlayerLocation data, Vec3 pos, @Nullable Player player) {
        poseStack.m_85836_();
        int distance = WayNameplateRenderer.getDistance(poseStack, renderTick, pos);
        MutableComponent dist = Component.m_237110_((String)"gui.way.distance", (Object[])new Object[]{distance});
        float mainScale = 0.0625f;
        float nameScale = 0.5f * mainScale;
        float distScale = 0.25f * mainScale;
        if (viewer.way$canSeeName()) {
            if (Way.hasIris()) {
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, data.name, 0.0f, 0.0f, 0.0f, data.nametagY, nameScale, WayNameplateRenderer.getNameHex(data, viewer, distance, player));
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, data.name, -10.5f, 0.0f, nameScale);
            } else {
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, data.name, -10.5f, 0.0f, nameScale);
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, data.name, 0.0f, 0.0f, 0.0f, data.nametagY, nameScale, WayNameplateRenderer.getNameHex(data, viewer, distance, player));
            }
        }
        if (viewer.way$canSeeDist()) {
            int distHex = viewer.way$canSeeColor() ? WayNameplateRenderer.getNameHex(data, viewer, distance, player) : 0x55FFFF;
            int n = distHex = viewer.way$canSeeName() ? 0xFFFFFF : distHex;
            if (Way.hasIris()) {
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, (Component)dist, 0.0f, 0.0f, 0.0f, data.nametagY + (viewer.way$canSeeName() ? -7.5f : 2.0f), distScale, distHex);
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, (Component)dist, viewer.way$canSeeName() ? -2.75f : -12.0f, 0.0f, distScale);
            } else {
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, (Component)dist, viewer.way$canSeeName() ? -2.75f : -12.0f, 0.0f, distScale);
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, (Component)dist, 0.0f, 0.0f, 0.0f, data.nametagY + (viewer.way$canSeeName() ? -7.5f : 2.0f), distScale, distHex);
            }
        }
        if (viewer.way$canSeeHead()) {
            float yOffset = -0.2f;
            if (viewer.way$canSeeDist()) {
                yOffset += 0.25f;
            }
            if (viewer.way$canSeeName()) {
                yOffset += 0.35f;
            }
            int headHex = viewer.way$canSeeName() || viewer.way$canSeeDist() ? data.hex : WayNameplateRenderer.getNameHex(data, viewer, distance, player);
            WayNameplateRenderer.renderPlayerIcon(poseStack, bufferSource, data.uuid, headHex, yOffset, 0.45f, viewer);
        }
        poseStack.m_85849_();
    }

    private static int getNameHex(PlayerLocation data, IWayPlayer viewer, int distance, @Nullable Player player) {
        int nameHex;
        int n = nameHex = viewer.way$canSeeColor() ? data.hex : -1;
        if (Way.colorDistance) {
            nameHex = ColorUtil.blendHexColors(nameHex, -1, (float)(distance - Way.minRender) / (float)Math.max(1, Way.maxRender));
        }
        if (player != null && Way.namePainFlash) {
            nameHex = ColorUtil.blendHexColors(nameHex, -65536, (float)player.f_20916_ / 10.0f);
        }
        if (Way.namePainGetRedder) {
            nameHex = ColorUtil.blendHexColors(-65536, nameHex, data.health / data.maxHealth);
        }
        return nameHex | 0xFF000000;
    }

    private static void renderText(PoseStack poseStack, MultiBufferSource bufferSource, ClientLevel level, Component name, float x, float y, float z, float yOffset, float scale, int color) {
        Minecraft client = Minecraft.m_91087_();
        Camera camera = client.m_91290_().f_114358_;
        Font font = client.f_91062_;
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(camera.m_90590_()));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(camera.m_90589_()));
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(scale, scale, scale);
        font.m_272077_(name, (float)(-font.m_92852_((FormattedText)name) / 2), yOffset + 0.1f, color, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.SEE_THROUGH, 0, level.m_7469_());
        poseStack.m_85849_();
    }

    private static void renderBackplate(PoseStack poseStack, MultiBufferSource bufferSource, Component text, float y, float z, float scale) {
        Font font = Minecraft.m_91087_().f_91062_;
        float width = font.m_92852_((FormattedText)text) + 2;
        int rgb = 50;
        int alpha = 120;
        VertexConsumer vConsumer = bufferSource.m_6299_(RenderType.m_269058_());
        float f = -width / 2.0f;
        Objects.requireNonNull(font);
        WayNameplateRenderer.renderBillboardingFace(poseStack, vConsumer, f, y, z, width, 9.0f, alpha, rgb, rgb, rgb, scale);
    }

    private static void renderPlayerIcon(PoseStack poseStack, MultiBufferSource bufferSource, UUID uuid, int hex, float y, float scale, IWayPlayer viewer) {
        float sizeOffset = viewer.way$canSeeHeadOutline() ? 0.1f : 0.0f;
        float x = -0.5f;
        float bgWidthHeight = 1.0f + sizeOffset * 2.0f;
        if (Way.hasIris()) {
            WayNameplateRenderer.renderHeadOutline(poseStack, bufferSource, hex, x - sizeOffset, y - sizeOffset, bgWidthHeight, scale, viewer);
            WayNameplateRenderer.renderHead(poseStack, bufferSource, uuid, x, y, scale);
            WayNameplateRenderer.renderThingInBackToFixLayering(poseStack, bufferSource, x - sizeOffset, y - sizeOffset, bgWidthHeight, scale);
        } else {
            WayNameplateRenderer.renderThingInBackToFixLayering(poseStack, bufferSource, x - sizeOffset, y - sizeOffset, bgWidthHeight, scale);
            WayNameplateRenderer.renderHeadOutline(poseStack, bufferSource, hex, x - sizeOffset, y - sizeOffset, bgWidthHeight, scale, viewer);
            WayNameplateRenderer.renderHead(poseStack, bufferSource, uuid, x, y, scale);
        }
    }

    private static void renderThingInBackToFixLayering(PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, float wh, float scale) {
        VertexConsumer vCon = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)FIX_RENDERING_THING));
        WayNameplateRenderer.renderBillboardingFace(poseStack, vCon, x, y, 0.002f, wh, wh, 0x3FFFFFF, scale);
    }

    private static void renderHeadOutline(PoseStack poseStack, MultiBufferSource bufferSource, int hex, float x, float y, float wh, float scale, IWayPlayer viewer) {
        if (viewer.way$canSeeHeadOutline()) {
            VertexConsumer vConBG = bufferSource.m_6299_(RenderType.m_269508_());
            WayNameplateRenderer.renderBillboardingFace(poseStack, vConBG, x, y, 0.001f, wh, wh, hex, scale);
        }
    }

    private static void renderHead(PoseStack poseStack, MultiBufferSource bufferSource, UUID uuid, float x, float y, float scale) {
        PlayerInfo info;
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null && (info = connection.m_104949_(uuid)) != null) {
            VertexConsumer vConSkin = bufferSource.m_6299_(RenderType.m_110500_((ResourceLocation)info.m_105337_()));
            WayNameplateRenderer.renderBillboardingFace(poseStack, vConSkin, x, y, 0.0f, 1.0f, 1.0f, 255, 255, 255, 255, scale);
        }
    }

    private static int getDistance(PoseStack poseStack, float renderTick, Vec3 tagPos) {
        Minecraft client = Minecraft.m_91087_();
        Camera camera = client.m_91290_().f_114358_;
        Vec3 cameraPos = camera.m_90583_();
        poseStack.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
        Vec3 playerPos = client.f_91074_.m_20318_(renderTick).m_82520_(0.0, 1.53, 0.0);
        Vec3 direction = playerPos.m_82546_(tagPos).m_82541_();
        double currentDistance = playerPos.m_82554_(tagPos);
        int maxOffsetDistance = 10;
        if (currentDistance >= (double)maxOffsetDistance) {
            tagPos = tagPos.m_82549_(direction.m_82490_(currentDistance - (double)maxOffsetDistance));
        }
        poseStack.m_85837_(tagPos.f_82479_, tagPos.f_82480_, tagPos.f_82481_);
        return (int)Math.floor(currentDistance);
    }

    private static void renderBillboardingFace(PoseStack poseStack, VertexConsumer vCon, float x, float y, float z, float width, float height, int hex, float scale) {
        FaceRenderingUtil.renderBillboardingFace(poseStack, vCon, x, y, z, UV[0], UV[1], UV[0], UV[1], width, height, hex, scale);
    }

    private static void renderBillboardingFace(PoseStack poseStack, VertexConsumer vCon, float x, float y, float z, float width, float height, int a, int r, int g, int b, float scale) {
        FaceRenderingUtil.renderBillboardingFace(poseStack, vCon, x, y, z, UV[0], UV[1], UV[0], UV[1], width, height, new int[]{a, r, g, b}, scale);
    }
}

