/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.common.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractWayCommand {
    public static final List<AbstractWayCommand> COMMANDS = new ArrayList<AbstractWayCommand>();
    protected static final String LANG_PREFIX = "commands.way.";
    protected final int permLvl;
    protected final String type;

    public AbstractWayCommand(int permLvl, String type) {
        this.permLvl = permLvl;
        this.type = type;
        COMMANDS.add(this);
    }

    public final void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"way").then(this.buildCommandStart().requires(source -> source.m_6761_(this.permLvl))));
    }

    private ArgumentBuilder<CommandSourceStack, ?> buildCommandStart() {
        ArrayList commandParts = new ArrayList();
        if (this.isOP()) {
            commandParts.add((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_((String)"admin"));
            if (this.multiTarget()) {
                commandParts.add(this.getPrePlayerArg());
                commandParts.add((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()));
            }
        }
        commandParts.add((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_((String)this.type));
        commandParts.addAll(this.getExtraCommandParts());
        int last = commandParts.size() - 1;
        ArgumentBuilder lastPart = ((ArgumentBuilder)commandParts.get(last)).executes(this::execute);
        commandParts.remove(last);
        return this.buildCommand(lastPart, commandParts);
    }

    protected ArgumentBuilder<CommandSourceStack, ?> getPrePlayerArg() {
        return Commands.m_82127_((String)"modify");
    }

    private ArgumentBuilder<CommandSourceStack, ?> buildCommand(ArgumentBuilder<CommandSourceStack, ?> command, List<ArgumentBuilder<CommandSourceStack, ?>> commandParts) {
        if (!commandParts.isEmpty()) {
            int last = commandParts.size() - 1;
            ArgumentBuilder<CommandSourceStack, ?> commandPart = commandParts.get(last);
            commandParts.remove(last);
            return this.buildCommand(commandPart.then(command), commandParts);
        }
        return command;
    }

    protected List<ArgumentBuilder<CommandSourceStack, ?>> getExtraCommandParts() {
        return new ArrayList();
    }

    protected final int execute(CommandContext<CommandSourceStack> context) {
        Optional<List<? extends Player>> optional = this.getPlayers(context);
        if (optional.isPresent()) {
            List<? extends Player> players = optional.get();
            players.forEach(player -> this.execute(context, (Player)player));
            this.successMSG(context, players);
            return players.size();
        }
        return 0;
    }

    protected abstract void execute(CommandContext<CommandSourceStack> var1, Player var2);

    protected boolean isOP() {
        return this.permLvl > 1;
    }

    protected Optional<List<? extends Player>> getPlayers(CommandContext<CommandSourceStack> context) {
        ServerPlayer player;
        if (this.multiTarget()) {
            try {
                List players = EntityArgument.m_91471_(context, (String)"players").stream().toList();
                return Optional.of(players);
            }
            catch (Exception players) {
                // empty catch block
            }
        }
        if ((player = ((CommandSourceStack)context.getSource()).m_230896_()) != null) {
            return Optional.of(List.of(player));
        }
        this.noEntityErrorMSG(context);
        return Optional.empty();
    }

    protected boolean multiTarget() {
        return this.isOP();
    }

    protected void successMSG(CommandContext<CommandSourceStack> context, Collection<? extends Player> players) {
        boolean bl = players.size() > 1;
        MutableComponent base = Component.m_237110_((String)(LANG_PREFIX + this.getID(context, players.iterator().next()) + (bl ? ".multi" : "")), (Object[])new Object[]{bl ? Integer.valueOf(players.size()) : players.iterator().next().m_5446_(), this.getNewValue(context)});
        this.sendSuccess(context, base, players.iterator().next());
    }

    protected String getID(CommandContext<CommandSourceStack> context, Player player) {
        return this.type;
    }

    protected void sendSuccess(CommandContext<CommandSourceStack> context, MutableComponent base, Player player) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> base, this.isOP());
    }

    protected abstract Object getNewValue(CommandContext<CommandSourceStack> var1);

    protected void noEntityErrorMSG(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.way.no_player"));
    }
}

