/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.common.command.commands.admin;

import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.deadlydiamond98.way.common.command.commands.AbstractWayCommand;
import net.deadlydiamond98.way.common.world.WaySavedData;
import net.deadlydiamond98.way.util.mixin.IWayPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ShowDistCommand
extends AbstractWayCommand {
    private final getPersistantState getter;
    private final setPersistantState setter;

    public ShowDistCommand(String type, getPersistantState getter, setPersistantState setter) {
        super(2, type);
        this.getter = getter;
        this.setter = setter;
    }

    public int getValue(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return this.getter.get(ShowDistCommand.getWayData(serverPlayer.m_20194_().m_129783_()));
        }
        return 4;
    }

    @Override
    protected void execute(CommandContext<CommandSourceStack> context, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.setter.set(ShowDistCommand.getWayData(serverPlayer.m_20194_().m_129783_()), this.getter.get(ShowDistCommand.getWayData(serverPlayer.m_20194_().m_129783_())));
            if (serverPlayer instanceof IWayPlayer) {
                player.m_20193_().m_6907_().forEach(player1 -> ((IWayPlayer)player1).way$updateRenderPreferences());
            }
        }
    }

    @Override
    protected Object getNewValue(CommandContext<CommandSourceStack> context) {
        return "If you're seeing this, something is wrong!";
    }

    @Override
    protected boolean multiTarget() {
        return false;
    }

    public static WaySavedData getWayData(ServerLevel world) {
        DimensionDataStorage manager = world.m_8895_();
        return (WaySavedData)manager.m_164861_(WaySavedData::fromNbt, WaySavedData::new, "way_saved_data");
    }

    @Override
    protected void successMSG(CommandContext<CommandSourceStack> context, Collection<? extends Player> players) {
        Player player = players.iterator().next();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            int currentDist = this.getter.get(ShowDistCommand.getWayData(player2.m_20194_().m_129783_()));
            MutableComponent base = Component.m_237110_((String)("commands.way." + this.getID(context, players.iterator().next())), (Object[])new Object[]{currentDist});
            this.sendSuccess(context, base, players.iterator().next());
        }
    }

    @Override
    protected String getID(CommandContext<CommandSourceStack> context, Player player) {
        return super.getID(context, player) + ".show";
    }

    @FunctionalInterface
    public static interface getPersistantState {
        public int get(WaySavedData var1);
    }

    @FunctionalInterface
    public static interface setPersistantState {
        public void set(WaySavedData var1, int var2);
    }
}

