/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.common.command.commands.color;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.deadlydiamond98.way.common.command.WayServerCommands;
import net.deadlydiamond98.way.common.command.commands.AbstractWayCommand;
import net.deadlydiamond98.way.util.mixin.IWayPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractColorCommand
extends AbstractWayCommand {
    private final String colorType;

    public AbstractColorCommand(int permLvl, String type) {
        super(permLvl, "color");
        this.colorType = type;
    }

    protected abstract int getColor(CommandContext<CommandSourceStack> var1);

    protected abstract boolean isColor(CommandContext<CommandSourceStack> var1);

    protected abstract String getColorName(CommandContext<CommandSourceStack> var1);

    protected abstract ArgumentBuilder<CommandSourceStack, ?> getColorArgument();

    @Override
    protected void execute(CommandContext<CommandSourceStack> context, Player player) {
        if (this.canRun(player)) {
            ((IWayPlayer)player).way$setColor(this.getColor(context));
            ((IWayPlayer)player).way$setClear(false);
        }
    }

    private boolean canRun(Player player) {
        return !WayServerCommands.LOCK_COLOR.getValue(player) || player.m_20310_(this.permLvl);
    }

    @Override
    protected Object getNewValue(CommandContext<CommandSourceStack> context) {
        return this.getColorName(context);
    }

    @Override
    protected List<ArgumentBuilder<CommandSourceStack, ?>> getExtraCommandParts() {
        return List.of(Commands.m_82127_((String)this.colorType), this.getColorArgument());
    }

    @Override
    protected String getID(CommandContext<CommandSourceStack> context, Player player) {
        if (!this.canRun(player)) {
            return "color.fail";
        }
        if (this.isColor(context)) {
            return super.getID(context, player);
        }
        return "color.reset";
    }

    @Override
    protected void sendSuccess(CommandContext<CommandSourceStack> context, MutableComponent base, Player player) {
        if (this.isColor(context) && this.canRun(player)) {
            base.m_7220_((Component)Component.m_237113_((String)"\u25a0").m_6270_(Style.f_131099_.m_178520_(this.getColor(context))));
        }
        Style errorColor = this.canRun(player) ? Style.f_131099_ : Style.f_131099_.m_131140_(ChatFormatting.DARK_RED);
        super.sendSuccess(context, base.m_130948_(errorColor), player);
    }
}

