/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.common.events;

import java.util.ArrayList;
import java.util.List;
import net.deadlydiamond98.way.common.command.WayServerCommands;
import net.deadlydiamond98.way.platform.Service;
import net.deadlydiamond98.way.util.PlayerLocation;
import net.deadlydiamond98.way.util.mixin.IWayPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WayTickingEvent {
    public static final List<PlayerLocation> PLAYER_POS = new ArrayList<PlayerLocation>();
    private static final int UPDATE_RATE = 5;

    public static void tick(Level level) {
        ArrayList toRender = new ArrayList();
        level.m_6907_().forEach(player -> {
            if (!player.m_20145_()) {
                toRender.add(player);
            }
        });
        level.m_6907_().forEach(sender -> {
            int rate = Math.max(1, WayServerCommands.PACKET_UPDATE_RATE.getValue((Player)sender));
            if (sender.f_19797_ % rate == 0) {
                Service.PLATFORM.sendS2CClearPacket((ServerPlayer)sender);
                for (Player player : toRender) {
                    if (!WayTickingEvent.canRenderNameplate(sender, player)) continue;
                    Service.PLATFORM.sendS2CPlayerList((ServerPlayer)sender, player);
                }
            }
        });
    }

    private static boolean canRenderNameplate(Player sender, Player player) {
        boolean focus;
        boolean inRange;
        IWayPlayer iWaySender = (IWayPlayer)sender;
        IWayPlayer iWayPlayer = (IWayPlayer)player;
        List<Component> targets = iWaySender.way$getFocusedPlayerNames();
        Integer focusColor = iWaySender.way$getFocusedColor();
        double distance = sender.m_20182_().m_82554_(player.m_20182_());
        boolean bl = inRange = distance >= (double)WayServerCommands.MIN_DIST.getValue(sender) && distance <= (double)WayServerCommands.MAX_DIST.getValue(sender);
        if (sender == player && !iWaySender.way$canSeeSelf() || !inRange && sender != player) {
            return false;
        }
        if (WayServerCommands.SEE_ALL.getValue(sender)) {
            return WayTickingEvent.canRender(sender, player, iWaySender, iWayPlayer.way$showPlayer());
        }
        boolean bl2 = focus = focusColor != null;
        if (WayServerCommands.SEE_TEAM_ONLY.getValue(sender)) {
            if (iWaySender.way$isClear() && iWayPlayer.way$isClear()) {
                return WayTickingEvent.canRender(sender, player, iWaySender, true);
            }
            return iWayPlayer.way$getColor() == iWaySender.way$getColor();
        }
        if (focus) {
            if (iWaySender.way$isClear() && iWayPlayer.way$isClear()) {
                return WayTickingEvent.canRender(sender, player, iWaySender, true);
            }
            return WayTickingEvent.canRender(sender, player, iWaySender, focusColor.intValue() == iWayPlayer.way$getColor());
        }
        if (!targets.isEmpty()) {
            return WayTickingEvent.canRender(sender, player, iWaySender, targets.contains(player.m_7755_()));
        }
        return WayTickingEvent.canRender(sender, player, iWaySender, WayServerCommands.FORCE_OPT.getValue(sender) || iWayPlayer.way$showPlayer());
    }

    private static boolean canRender(Player sender, Player player, IWayPlayer iWaySender, boolean returnVal) {
        if (sender.m_20270_((Entity)player) < 100.0f && sender != player && iWaySender.way$hideIfVisible()) {
            ClipContext context = new ClipContext(sender.m_146892_(), player.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
            BlockHitResult hitResult = sender.m_9236_().m_45547_(context);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                return returnVal;
            }
            return false;
        }
        return returnVal;
    }
}

