/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.mixin;

import java.util.ArrayList;
import java.util.List;
import net.deadlydiamond98.way.common.command.WayServerCommands;
import net.deadlydiamond98.way.platform.Service;
import net.deadlydiamond98.way.util.mixin.IWayPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerMixin
implements IWayPlayer {
    @Unique
    private boolean way$showPlayer = true;
    @Unique
    private int way$color = 0xFFFFFF;
    @Unique
    private boolean way$isClear = true;
    @Unique
    private List<Component> way$players = new ArrayList<Component>();
    @Unique
    private Integer way$focusedColor = null;
    @Unique
    private boolean way$toggle = true;
    @Unique
    private boolean way$hideIfVisible = false;
    @Unique
    private boolean way$seeNames = true;
    @Unique
    private boolean way$seeDist = true;
    @Unique
    private boolean way$seeColors = true;
    @Unique
    private boolean way$seeOutlines = false;
    @Unique
    private boolean way$seeHead = true;
    @Unique
    private boolean way$seeHeadOutline = true;
    @Unique
    private boolean way$seeSelf = false;

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    private void way$attack(Entity entity, CallbackInfo ci) {
        ServerPlayer serverPlayer;
        IWayPlayer wayPlayer;
        Player player = (Player)this;
        if (entity instanceof IWayPlayer && (wayPlayer = (IWayPlayer)entity).way$getColor() == this.way$getColor() && player instanceof ServerPlayer && WayServerCommands.NO_FRIENDLY_FIRE.getValue((Player)(serverPlayer = (ServerPlayer)player))) {
            ci.cancel();
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void way$readAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        this.way$showPlayer = nbt.m_128471_("showPlayerWAY");
        this.way$color = nbt.m_128451_("colorWAY");
        this.way$isClear = nbt.m_128471_("clearWay");
        this.way$toggle = nbt.m_128471_("toggleWay");
        this.way$hideIfVisible = nbt.m_128471_("hideIfVisWay");
        this.way$seeNames = nbt.m_128471_("seeNameWay");
        this.way$seeDist = nbt.m_128471_("seeDistWay");
        this.way$seeColors = nbt.m_128471_("seeColorWay");
        this.way$seeOutlines = nbt.m_128471_("seeOutlineWay");
        this.way$seeSelf = nbt.m_128471_("seeSelfWay");
        this.way$seeHead = nbt.m_128471_("seeHeadWay");
        this.way$seeHeadOutline = nbt.m_128471_("seeHeadOutlineWay");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void way$addAdditionalSaveData(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128379_("showPlayerWAY", this.way$showPlayer);
        nbt.m_128405_("colorWAY", this.way$color);
        nbt.m_128379_("clearWay", this.way$isClear);
        nbt.m_128379_("toggleWay", this.way$toggle);
        nbt.m_128379_("hideIfVisWay", this.way$hideIfVisible);
        nbt.m_128379_("seeNameWay", this.way$seeNames);
        nbt.m_128379_("seeDistWay", this.way$seeDist);
        nbt.m_128379_("seeColorWay", this.way$seeColors);
        nbt.m_128379_("seeOutlineWay", this.way$seeOutlines);
        nbt.m_128379_("seeSelfWay", this.way$seeSelf);
        nbt.m_128379_("seeHeadWay", this.way$seeHead);
        nbt.m_128379_("seeHeadOutlineWay", this.way$seeHeadOutline);
    }

    @Override
    public void way$setToggle(boolean bool) {
        this.way$toggle = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$getToggle() {
        return this.way$toggle;
    }

    @Override
    public void way$setHideIfVisible(boolean bool) {
        this.way$hideIfVisible = bool;
    }

    @Override
    public boolean way$hideIfVisible() {
        return this.way$hideIfVisible;
    }

    @Override
    public void way$setShowing(boolean show) {
        this.way$showPlayer = show;
    }

    @Override
    public boolean way$showPlayer() {
        return this.way$showPlayer;
    }

    @Override
    public void way$setColor(int hex) {
        this.way$color = hex | 0xFF000000;
    }

    @Override
    public int way$getColor() {
        return this.way$color | 0xFF000000;
    }

    @Override
    public void way$setClear(boolean bl) {
        this.way$isClear = bl;
    }

    @Override
    public boolean way$isClear() {
        return this.way$isClear;
    }

    @Override
    public void way$setFocusedPlayerNames(List<Component> players) {
        this.way$players = players;
    }

    @Override
    public List<Component> way$getFocusedPlayerNames() {
        return this.way$players;
    }

    @Override
    public void way$setFocusedColor(@Nullable Integer color) {
        if (color != null) {
            color = color | 0xFF000000;
        }
        this.way$focusedColor = color;
    }

    @Override
    @Nullable
    public Integer way$getFocusedColor() {
        if (this.way$focusedColor != null) {
            return this.way$focusedColor | 0xFF000000;
        }
        return null;
    }

    @Override
    public void way$updateRenderPreferences() {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            ServerPlayer sender = (ServerPlayer)player;
            Service.PLATFORM.sendS2CRenderingPacket(sender, this.way$toggle, this.way$seeNames, this.way$seeDist, this.way$seeColors, this.way$seeOutlines, this.way$seeHead, this.way$seeHeadOutline, WayServerCommands.COLOR_DISTANCE.getValue((Player)sender), WayServerCommands.NAME_PAIN_FLASH.getValue((Player)sender), WayServerCommands.NAME_PAIN_REDDER.getValue((Player)sender), WayServerCommands.MIN_DIST.getValue((Player)sender), WayServerCommands.MAX_DIST.getValue((Player)sender));
        }
    }

    @Override
    public void way$setSeeName(boolean bool) {
        this.way$seeNames = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$canSeeName() {
        return this.way$seeNames;
    }

    @Override
    public void way$setSeeDist(boolean bool) {
        this.way$seeDist = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$canSeeDist() {
        return this.way$seeDist;
    }

    @Override
    public void way$setSeeColor(boolean bool) {
        this.way$seeColors = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$canSeeColor() {
        return this.way$seeColors;
    }

    @Override
    public void way$setSeeOutline(boolean bool) {
        this.way$seeOutlines = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$canSeeOutline() {
        return this.way$seeOutlines;
    }

    @Override
    public void way$setSeeHead(boolean bool) {
        this.way$seeHead = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$canSeeHead() {
        return this.way$seeHead;
    }

    @Override
    public void way$setSeeHeadOutline(boolean bool) {
        this.way$seeHeadOutline = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$canSeeHeadOutline() {
        return this.way$seeHeadOutline;
    }

    @Override
    public void way$setSeeSelf(boolean bool) {
        this.way$seeSelf = bool;
        this.way$updateRenderPreferences();
    }

    @Override
    public boolean way$canSeeSelf() {
        return this.way$seeSelf;
    }
}

