/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.client.renderer;

import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.deadlydiamond98.way.Way;
import net.deadlydiamond98.way.client.WayKeybindings;
import net.deadlydiamond98.way.common.events.WayTickingEvent;
import net.deadlydiamond98.way.util.ColorUtil;
import net.deadlydiamond98.way.util.FaceRenderingUtil;
import net.deadlydiamond98.way.util.PlayerLocation;
import net.deadlydiamond98.way.util.mixin.IGlowingWayPlayer;
import net.deadlydiamond98.way.util.mixin.IWayPlayer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

public class WayNameplateRenderer {
    private static final class_2960 FIX_RENDERING_THING = new class_2960("way", "textures/plz_work.png");
    private static final float[] UV = new float[]{0.125f, 0.25f};
    private static final int NAMETAG_RENDER_CUTTOFF = 100;

    public static void render(class_4587 poseStack, class_4597 bufferSource, class_638 level, float renderTick) {
        if (WayKeybindings.renderNameOverlay()) {
            class_310 client = class_310.method_1551();
            class_746 user = client.field_1724;
            if (user instanceof IWayPlayer) {
                IWayPlayer wayPlayer = (IWayPlayer)user;
                level.method_18456().forEach(player -> ((IGlowingWayPlayer)player).way$setGlowRendering(false));
                new ArrayList<PlayerLocation>(WayTickingEvent.PLAYER_POS).forEach(playerData -> {
                    if (playerData.getEyePosition().method_1022(user.method_5836(renderTick)) > 100.0) {
                        class_243 pos = playerData.getPosition().method_1031(0.0, (double)playerData.nametagY, 0.0);
                        WayNameplateRenderer.renderNameplate(poseStack, bufferSource, level, renderTick, wayPlayer, playerData, pos, null);
                    } else {
                        level.method_18456().forEach(player -> {
                            boolean thirdPerson = user.equals(player) && !client.method_1561().field_4686.method_19333();
                            boolean invis = player.method_21751() || player.method_5767();
                            boolean isSame = playerData.name.getString().equals(player.method_5477().getString());
                            if (isSame && !thirdPerson && !invis && player.method_5739((class_1297)user) <= 100.0f) {
                                class_243 pos = player.method_30950(renderTick).method_1031(0.0, (double)player.method_51152(), 0.0);
                                WayNameplateRenderer.renderNameplate(poseStack, bufferSource, level, renderTick, wayPlayer, playerData, pos, (class_1657)player);
                                if (((IWayPlayer)user).way$canSeeOutline()) {
                                    ((IGlowingWayPlayer)player).way$setOutlineColor(playerData.hex);
                                    ((IGlowingWayPlayer)player).way$setGlowRendering(true);
                                } else {
                                    ((IGlowingWayPlayer)player).way$setGlowRendering(false);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private static void renderNameplate(class_4587 poseStack, class_4597 bufferSource, class_638 level, float renderTick, IWayPlayer viewer, PlayerLocation data, class_243 pos, @Nullable class_1657 player) {
        poseStack.method_22903();
        int distance = WayNameplateRenderer.getDistance(poseStack, renderTick, pos);
        class_5250 dist = class_2561.method_43469((String)"gui.way.distance", (Object[])new Object[]{distance});
        float mainScale = 0.0625f;
        float nameScale = 0.5f * mainScale;
        float distScale = 0.25f * mainScale;
        if (viewer.way$canSeeName()) {
            if (Way.hasIris()) {
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, data.name, 0.0f, 0.0f, 0.0f, data.nametagY, nameScale, WayNameplateRenderer.getNameHex(data, viewer, distance, player));
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, data.name, -10.5f, 0.0f, nameScale);
            } else {
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, data.name, -10.5f, 0.0f, nameScale);
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, data.name, 0.0f, 0.0f, 0.0f, data.nametagY, nameScale, WayNameplateRenderer.getNameHex(data, viewer, distance, player));
            }
        }
        if (viewer.way$canSeeDist()) {
            int distHex = viewer.way$canSeeColor() ? WayNameplateRenderer.getNameHex(data, viewer, distance, player) : 0x55FFFF;
            int n = distHex = viewer.way$canSeeName() ? 0xFFFFFF : distHex;
            if (Way.hasIris()) {
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, (class_2561)dist, 0.0f, 0.0f, 0.0f, data.nametagY + (viewer.way$canSeeName() ? -7.5f : 2.0f), distScale, distHex);
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, (class_2561)dist, viewer.way$canSeeName() ? -2.75f : -12.0f, 0.0f, distScale);
            } else {
                WayNameplateRenderer.renderBackplate(poseStack, bufferSource, (class_2561)dist, viewer.way$canSeeName() ? -2.75f : -12.0f, 0.0f, distScale);
                WayNameplateRenderer.renderText(poseStack, bufferSource, level, (class_2561)dist, 0.0f, 0.0f, 0.0f, data.nametagY + (viewer.way$canSeeName() ? -7.5f : 2.0f), distScale, distHex);
            }
        }
        if (viewer.way$canSeeHead()) {
            float yOffset = -0.2f;
            if (viewer.way$canSeeDist()) {
                yOffset += 0.25f;
            }
            if (viewer.way$canSeeName()) {
                yOffset += 0.35f;
            }
            int headHex = viewer.way$canSeeName() || viewer.way$canSeeDist() ? data.hex : WayNameplateRenderer.getNameHex(data, viewer, distance, player);
            WayNameplateRenderer.renderPlayerIcon(poseStack, bufferSource, data.uuid, headHex, yOffset, 0.45f, viewer);
        }
        poseStack.method_22909();
    }

    private static int getNameHex(PlayerLocation data, IWayPlayer viewer, int distance, @Nullable class_1657 player) {
        int nameHex;
        int n = nameHex = viewer.way$canSeeColor() ? data.hex : -1;
        if (Way.colorDistance) {
            nameHex = ColorUtil.blendHexColors(nameHex, -1, (float)(distance - Way.minRender) / (float)Math.max(1, Way.maxRender));
        }
        if (player != null && Way.namePainFlash) {
            nameHex = ColorUtil.blendHexColors(nameHex, -65536, (float)player.field_6235 / 10.0f);
        }
        if (Way.namePainGetRedder) {
            nameHex = ColorUtil.blendHexColors(-65536, nameHex, data.health / data.maxHealth);
        }
        return nameHex | 0xFF000000;
    }

    private static void renderText(class_4587 poseStack, class_4597 bufferSource, class_638 level, class_2561 name, float x, float y, float z, float yOffset, float scale, int color) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.method_1561().field_4686;
        class_327 font = client.field_1772;
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330()));
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(camera.method_19329()));
        poseStack.method_46416(x, y, z);
        poseStack.method_22905(scale, scale, scale);
        font.method_30882(name, (float)(-font.method_27525((class_5348)name) / 2), yOffset + 0.1f, color, false, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33994, 0, level.method_8315());
        poseStack.method_22909();
    }

    private static void renderBackplate(class_4587 poseStack, class_4597 bufferSource, class_2561 text, float y, float z, float scale) {
        class_327 font = class_310.method_1551().field_1772;
        float width = font.method_27525((class_5348)text) + 2;
        int rgb = 50;
        int alpha = 120;
        class_4588 vConsumer = bufferSource.getBuffer(class_1921.method_49045());
        float f = -width / 2.0f;
        Objects.requireNonNull(font);
        WayNameplateRenderer.renderBillboardingFace(poseStack, vConsumer, f, y, z, width, 9.0f, alpha, rgb, rgb, rgb, scale);
    }

    private static void renderPlayerIcon(class_4587 poseStack, class_4597 bufferSource, UUID uuid, int hex, float y, float scale, IWayPlayer viewer) {
        float sizeOffset = viewer.way$canSeeHeadOutline() ? 0.1f : 0.0f;
        float x = -0.5f;
        float bgWidthHeight = 1.0f + sizeOffset * 2.0f;
        if (Way.hasIris()) {
            WayNameplateRenderer.renderHeadOutline(poseStack, bufferSource, hex, x - sizeOffset, y - sizeOffset, bgWidthHeight, scale, viewer);
            WayNameplateRenderer.renderHead(poseStack, bufferSource, uuid, x, y, scale);
        } else {
            WayNameplateRenderer.renderThingInBackToFixLayering(poseStack, bufferSource, x - sizeOffset, y - sizeOffset, bgWidthHeight, scale);
            WayNameplateRenderer.renderHeadOutline(poseStack, bufferSource, hex, x - sizeOffset, y - sizeOffset, bgWidthHeight, scale, viewer);
            WayNameplateRenderer.renderHead(poseStack, bufferSource, uuid, x, y, scale);
        }
    }

    private static void renderThingInBackToFixLayering(class_4587 poseStack, class_4597 bufferSource, float x, float y, float wh, float scale) {
        class_4588 vCon = bufferSource.getBuffer(class_1921.method_23578((class_2960)FIX_RENDERING_THING));
        WayNameplateRenderer.renderBillboardingFace(poseStack, vCon, x, y, 0.002f, wh, wh, 0x3FFFFFF, scale);
    }

    private static void renderHeadOutline(class_4587 poseStack, class_4597 bufferSource, int hex, float x, float y, float wh, float scale, IWayPlayer viewer) {
        if (viewer.way$canSeeHeadOutline()) {
            class_4588 vConBG = bufferSource.getBuffer(class_1921.method_49046());
            WayNameplateRenderer.renderBillboardingFace(poseStack, vConBG, x, y, 0.001f, wh, wh, hex, scale);
        }
    }

    private static void renderHead(class_4587 poseStack, class_4597 bufferSource, UUID uuid, float x, float y, float scale) {
        class_640 info;
        class_634 connection = class_310.method_1551().method_1562();
        if (connection != null && (info = connection.method_2871(uuid)) != null) {
            class_4588 vConSkin = bufferSource.getBuffer(class_1921.method_23030((class_2960)info.method_2968()));
            WayNameplateRenderer.renderBillboardingFace(poseStack, vConSkin, x, y, 0.0f, 1.0f, 1.0f, 255, 255, 255, 255, scale);
        }
    }

    private static int getDistance(class_4587 poseStack, float renderTick, class_243 tagPos) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.method_1561().field_4686;
        class_243 cameraPos = camera.method_19326();
        poseStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        class_243 playerPos = client.field_1724.method_30950(renderTick).method_1031(0.0, 1.53, 0.0);
        class_243 direction = playerPos.method_1020(tagPos).method_1029();
        double currentDistance = playerPos.method_1022(tagPos);
        int maxOffsetDistance = 10;
        if (currentDistance >= (double)maxOffsetDistance) {
            tagPos = tagPos.method_1019(direction.method_1021(currentDistance - (double)maxOffsetDistance));
        }
        poseStack.method_22904(tagPos.field_1352, tagPos.field_1351, tagPos.field_1350);
        return (int)Math.floor(currentDistance);
    }

    private static void renderBillboardingFace(class_4587 poseStack, class_4588 vCon, float x, float y, float z, float width, float height, int hex, float scale) {
        FaceRenderingUtil.renderBillboardingFace(poseStack, vCon, x, y, z, UV[0], UV[1], UV[0], UV[1], width, height, hex, scale);
    }

    private static void renderBillboardingFace(class_4587 poseStack, class_4588 vCon, float x, float y, float z, float width, float height, int a, int r, int g, int b, float scale) {
        FaceRenderingUtil.renderBillboardingFace(poseStack, vCon, x, y, z, UV[0], UV[1], UV[0], UV[1], width, height, new int[]{a, r, g, b}, scale);
    }
}

