/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.common.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class HexColorArgument
implements ArgumentType<String> {
    public static HexColorArgument color() {
        return new HexColorArgument();
    }

    public static String getString(CommandContext<class_2168> context, String color) {
        return HexColorArgument.getFormattedHexString((String)context.getArgument(color, String.class)).toUpperCase();
    }

    public static int getInt(CommandContext<class_2168> context, String color) {
        try {
            return Color.decode(HexColorArgument.getString(context, color)).getRGB();
        }
        catch (Exception e) {
            return 0xFFFFFF;
        }
    }

    private static String getFormattedHexString(String string) {
        String colorString = HexColorArgument.stripStart(string, "#", "0x");
        return "#" + colorString;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        String string = reader.readString();
        String hex = HexColorArgument.getFormattedHexString(string);
        if (hex.length() == 7 && hex.replaceAll("[g-z]", "").length() == 7) {
            return string;
        }
        throw HexColorArgument.invalidArgException(string);
    }

    private static String stripStart(String string, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!string.startsWith(prefix)) continue;
            return string.substring(prefix.length());
        }
        return string;
    }

    public Collection<String> getExamples() {
        return Arrays.asList("#FFFFFF", "#FF0000", "#00FFAA");
    }

    public static CommandSyntaxException invalidArgException(String string) {
        return new DynamicCommandExceptionType(obj -> class_2561.method_43469((String)"way.argument.hex.invalid", (Object[])new Object[]{obj})).create((Object)string);
    }
}

