/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.way.common.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public abstract class AbstractWayCommand {
    public static final List<AbstractWayCommand> COMMANDS = new ArrayList<AbstractWayCommand>();
    protected static final String LANG_PREFIX = "commands.way.";
    protected final int permLvl;
    protected final String type;

    public AbstractWayCommand(int permLvl, String type) {
        this.permLvl = permLvl;
        this.type = type;
        COMMANDS.add(this);
    }

    public final void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"way").then(this.buildCommandStart().requires(source -> source.method_9259(this.permLvl))));
    }

    private ArgumentBuilder<class_2168, ?> buildCommandStart() {
        ArrayList commandParts = new ArrayList();
        if (this.isOP()) {
            commandParts.add((ArgumentBuilder<class_2168, ?>)class_2170.method_9247((String)"admin"));
            if (this.multiTarget()) {
                commandParts.add(this.getPrePlayerArg());
                commandParts.add((ArgumentBuilder<class_2168, ?>)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()));
            }
        }
        commandParts.add((ArgumentBuilder<class_2168, ?>)class_2170.method_9247((String)this.type));
        commandParts.addAll(this.getExtraCommandParts());
        int last = commandParts.size() - 1;
        ArgumentBuilder lastPart = ((ArgumentBuilder)commandParts.get(last)).executes(this::execute);
        commandParts.remove(last);
        return this.buildCommand(lastPart, commandParts);
    }

    protected ArgumentBuilder<class_2168, ?> getPrePlayerArg() {
        return class_2170.method_9247((String)"modify");
    }

    private ArgumentBuilder<class_2168, ?> buildCommand(ArgumentBuilder<class_2168, ?> command, List<ArgumentBuilder<class_2168, ?>> commandParts) {
        if (!commandParts.isEmpty()) {
            int last = commandParts.size() - 1;
            ArgumentBuilder<class_2168, ?> commandPart = commandParts.get(last);
            commandParts.remove(last);
            return this.buildCommand(commandPart.then(command), commandParts);
        }
        return command;
    }

    protected List<ArgumentBuilder<class_2168, ?>> getExtraCommandParts() {
        return new ArrayList();
    }

    protected final int execute(CommandContext<class_2168> context) {
        Optional<List<? extends class_1657>> optional = this.getPlayers(context);
        if (optional.isPresent()) {
            List<? extends class_1657> players = optional.get();
            players.forEach(player -> this.execute(context, (class_1657)player));
            this.successMSG(context, players);
            return players.size();
        }
        return 0;
    }

    protected abstract void execute(CommandContext<class_2168> var1, class_1657 var2);

    protected boolean isOP() {
        return this.permLvl > 1;
    }

    protected Optional<List<? extends class_1657>> getPlayers(CommandContext<class_2168> context) {
        class_3222 player;
        if (this.multiTarget()) {
            try {
                List players = class_2186.method_9310(context, (String)"players").stream().toList();
                return Optional.of(players);
            }
            catch (Exception players) {
                // empty catch block
            }
        }
        if ((player = ((class_2168)context.getSource()).method_44023()) != null) {
            return Optional.of(List.of(player));
        }
        this.noEntityErrorMSG(context);
        return Optional.empty();
    }

    protected boolean multiTarget() {
        return this.isOP();
    }

    protected void successMSG(CommandContext<class_2168> context, Collection<? extends class_1657> players) {
        boolean bl = players.size() > 1;
        class_5250 base = class_2561.method_43469((String)(LANG_PREFIX + this.getID(context, players.iterator().next()) + (bl ? ".multi" : "")), (Object[])new Object[]{bl ? Integer.valueOf(players.size()) : players.iterator().next().method_5476(), this.getNewValue(context)});
        this.sendSuccess(context, base, players.iterator().next());
    }

    protected String getID(CommandContext<class_2168> context, class_1657 player) {
        return this.type;
    }

    protected void sendSuccess(CommandContext<class_2168> context, class_5250 base, class_1657 player) {
        ((class_2168)context.getSource()).method_9226(() -> base, this.isOP());
    }

    protected abstract Object getNewValue(CommandContext<class_2168> var1);

    protected void noEntityErrorMSG(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.way.no_player"));
    }
}

