/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.unlocked_typing.mixin;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin {
    @Shadow
    @Final
    protected SignBlockEntity sign;
    @Shadow
    @Final
    private String[] messages;
    @Shadow
    private SignText text;
    @Unique
    private static final int UNLOCKED_TYPING$OFFSET = 100;

    @Shadow
    protected abstract Vector3f getSignTextScale();

    @Inject(at={@At(value="TAIL")}, method={"renderSignText"})
    private void unlocked_typing$renderSignText(GuiGraphics guiGraphics, CallbackInfo ci) {
        Font font = ((Screen)this).getFont();
        Vector3f vector3f = this.getSignTextScale();
        guiGraphics.pose().scale(vector3f.x(), vector3f.y());
        int textColor = -2236963;
        int yOffset = 4 * this.sign.getTextLineHeight() / 2;
        boolean drewHelperText = false;
        for (int messageIndex = 0; messageIndex < this.messages.length; ++messageIndex) {
            String message = this.text.getMessage(messageIndex, false).getString();
            int textX = -font.width(message) / 2;
            if (!drewHelperText) {
                guiGraphics.drawString(font, FormattedCharSequence.forward((String)Component.translatable((String)"unlocked_typing.editableText").getString(), (Style)Style.EMPTY.withUnderlined(Boolean.valueOf(true))), textX + 100, messageIndex * this.sign.getTextLineHeight() - yOffset - 11, textColor, true);
                drewHelperText = true;
            }
            if (message == null) continue;
            if (font.isBidirectional()) {
                message = font.bidirectionalShaping(message);
            }
            guiGraphics.drawString(font, FormattedCharSequence.forward((String)message, (Style)Style.EMPTY), textX + 100, messageIndex * this.sign.getTextLineHeight() - yOffset, textColor, true);
        }
    }
}

