/*
 * Decompiled with CFR 0.152.
 */
package com.shakkas.diversitydelight.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class LowerDoubleFruitingCropBlock
extends CropBlock {
    public static final int PREMATURE_MAX_AGE = 4;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Supplier<Item> cropDrop;
    private final Supplier<Item> seedDrop;
    private final Supplier<Block> upperCrop;

    public LowerDoubleFruitingCropBlock(BlockBehaviour.Properties properties, Supplier<Item> cropDrop, Supplier<Item> seedDrop, Supplier<Block> upperCrop) {
        super(properties);
        this.cropDrop = cropDrop;
        this.seedDrop = seedDrop;
        this.upperCrop = upperCrop;
    }

    protected Item getCropDrop() {
        return this.cropDrop.get();
    }

    protected Item getSeedDrop() {
        return this.seedDrop.get();
    }

    protected Block getUpperCrop() {
        return this.upperCrop.get();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    protected ItemLike getBaseSeedId() {
        return this.getSeedDrop();
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9) {
            int age = this.getAge(state);
            boolean upperExists = level.getBlockState(pos.above()).is(this.getUpperCrop());
            float speed = LowerDoubleFruitingCropBlock.getGrowthSpeed((BlockState)state, (BlockGetter)level, (BlockPos)pos);
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / speed) + 1) == 0 ? 1 : 0) != 0)) {
                if (age == this.getMaxAge()) {
                    if (!upperExists && level.getBlockState(pos.above()).isAir()) {
                        level.setBlockAndUpdate(pos.above(), this.getUpperCrop().defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    }
                } else if (age >= 4) {
                    int upperAge;
                    if (!upperExists && level.getBlockState(pos.above()).isAir()) {
                        level.setBlockAndUpdate(pos.above(), this.getUpperCrop().defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    }
                    if (upperExists && (upperAge = ((Integer)level.getBlockState(pos.above()).getValue((Property)this.getAgeProperty())).intValue()) >= 4) {
                        level.setBlock(pos, this.getStateForAge(age + 1), 2);
                        CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    }
                } else {
                    level.setBlock(pos, this.getStateForAge(age + 1), 2);
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        boolean isMature;
        int age = (Integer)state.getValue((Property)this.getAgeProperty());
        boolean bl = isMature = age == this.getMaxAge();
        if (isMature) {
            int quantity = 1 + level.random.nextInt(2);
            LowerDoubleFruitingCropBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getCropDrop(), quantity));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(4)), 2);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }
}

