/*
 * Decompiled with CFR 0.152.
 */
package com.shakkas.diversitydelight.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class LowerDoubleSupportCropBlock
extends CropBlock {
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private final Supplier<Item> seedDrop;
    private final Supplier<Block> upperCrop;

    public LowerDoubleSupportCropBlock(BlockBehaviour.Properties properties, Supplier<Item> seedDrop, Supplier<Block> upperCrop) {
        super(properties);
        this.seedDrop = seedDrop;
        this.upperCrop = upperCrop;
    }

    protected Item getSeedDrop() {
        return this.seedDrop.get();
    }

    protected Block getUpperCrop() {
        return this.upperCrop.get();
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    protected ItemLike getBaseSeedId() {
        return this.getSeedDrop();
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9) {
            int age = this.getAge(state);
            boolean upperExists = level.getBlockState(pos.above()).is(this.getUpperCrop());
            float speed = LowerDoubleSupportCropBlock.getGrowthSpeed((BlockState)state, (BlockGetter)level, (BlockPos)pos);
            if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / speed) + 1) == 0 ? 1 : 0) != 0)) {
                if (age == this.getMaxAge()) {
                    if (!upperExists && level.getBlockState(pos.above()).isAir()) {
                        level.setBlockAndUpdate(pos.above(), this.getUpperCrop().defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                    }
                } else {
                    level.setBlock(pos, this.getStateForAge(age + 1), 2);
                    CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
                }
            }
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }
}

