/*
 * Decompiled with CFR 0.152.
 */
package com.shakkas.diversitydelight.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.CommonHooks;

public class WormBinBlock
extends ComposterBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public WormBinBlock(BlockBehaviour.Properties properties) {
        super(properties.randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int i = (Integer)state.getValue((Property)LEVEL);
        if (i == 7) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is((Block)this)) {
            level.invalidateCapabilities(pos);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)LEVEL) != 0;
    }

    public boolean isNearbyBonemealable(ServerLevel level, BlockPos pos) {
        int xDist = 5;
        int yDist = 1;
        int zDist = 5;
        BlockPos vertex1 = pos.offset(-xDist, 0, -zDist);
        BlockPos vertex2 = pos.offset(xDist, yDist, zDist);
        for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)vertex1, (BlockPos)vertex2)) {
            BlockState targetState = level.getBlockState(targetPos);
            if (!(targetState.getBlock() instanceof BonemealableBlock)) continue;
            return true;
        }
        return false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        int xDist = 5;
        int yDist = 1;
        int zDist = 5;
        int contentLevel = (Integer)state.getValue((Property)LEVEL);
        if (random.nextInt(30) == 0 && this.isNearbyBonemealable(level, pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(contentLevel - 1)), 3);
            BlockPos vertex1 = pos.offset(-xDist, 0, -zDist);
            BlockPos vertex2 = pos.offset(xDist, yDist, zDist);
            for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)vertex1, (BlockPos)vertex2)) {
                BlockState targetState = level.getBlockState(targetPos);
                Block block = targetState.getBlock();
                if (!(block instanceof BonemealableBlock)) continue;
                BonemealableBlock growable = (BonemealableBlock)block;
                if (!CommonHooks.canCropGrow((Level)level, (BlockPos)targetPos, (BlockState)targetState, (random.nextInt(8) == 0 ? 1 : 0) != 0) || !growable.isValidBonemealTarget((LevelReader)level, targetPos, targetState)) continue;
                growable.performBonemeal(level, level.random, targetPos, targetState);
                CommonHooks.fireCropGrowPost((Level)level, (BlockPos)targetPos, (BlockState)targetState);
                level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)targetPos.getX() + 0.5, (double)targetPos.getY() + 1.0, (double)targetPos.getZ() + 0.5, 5, 0.25, 0.25, 0.25, 0.05);
            }
        }
    }
}

