/*
 * Decompiled with CFR 0.152.
 */
package com.shakkas.diversitydelight.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;

public record CondimentProperties(int nutritionBonus, float saturationBonus, boolean alwaysEdible, boolean fast, List<FoodProperties.PossibleEffect> extraEffects) {
    public static final Codec<CondimentProperties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("nutritionBonus", (Object)0).forGetter(CondimentProperties::nutritionBonus), (App)Codec.FLOAT.optionalFieldOf("saturationBonus", (Object)Float.valueOf(0.0f)).forGetter(CondimentProperties::saturationBonus), (App)Codec.BOOL.optionalFieldOf("alwaysEdible", (Object)false).forGetter(CondimentProperties::alwaysEdible), (App)Codec.BOOL.optionalFieldOf("fast", (Object)false).forGetter(CondimentProperties::fast), (App)Codec.list((Codec)FoodProperties.PossibleEffect.CODEC).optionalFieldOf("extraEffects", List.of()).forGetter(CondimentProperties::extraEffects)).apply((Applicative)instance, CondimentProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CondimentProperties> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CondimentProperties::nutritionBonus, (StreamCodec)ByteBufCodecs.FLOAT, CondimentProperties::saturationBonus, (StreamCodec)ByteBufCodecs.BOOL, CondimentProperties::alwaysEdible, (StreamCodec)ByteBufCodecs.BOOL, CondimentProperties::fast, (StreamCodec)FoodProperties.PossibleEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), CondimentProperties::extraEffects, CondimentProperties::new);
    public static final CondimentProperties EMPTY = new CondimentProperties(0, 0.0f, false, false, List.of());

    public static class Builder {
        private int nutritionBonus = 0;
        private float saturationBonus = 0.0f;
        private boolean alwaysEdible = false;
        private boolean fast = false;
        private final ImmutableList.Builder<FoodProperties.PossibleEffect> effects = ImmutableList.builder();

        public Builder nutritionBonus(int nutritionBonus) {
            this.nutritionBonus = nutritionBonus;
            return this;
        }

        public Builder saturationBonus(float saturationBonus) {
            this.saturationBonus = saturationBonus;
            return this;
        }

        public Builder alwaysEdible(boolean alwaysEdible) {
            this.alwaysEdible = alwaysEdible;
            return this;
        }

        public Builder fast(boolean fast) {
            this.fast = fast;
            return this;
        }

        public Builder effect(Supplier<MobEffectInstance> effectIn, float probability) {
            this.effects.add((Object)new FoodProperties.PossibleEffect(effectIn, probability));
            return this;
        }

        public CondimentProperties build() {
            return new CondimentProperties(this.nutritionBonus, this.saturationBonus, this.alwaysEdible, this.fast, (List<FoodProperties.PossibleEffect>)this.effects.build());
        }
    }
}

