/*
 * Decompiled with CFR 0.152.
 */
package com.shakkas.diversitydelight.datagen;

import com.shakkas.diversitydelight.block.ModBlocks;
import com.shakkas.diversitydelight.block.custom.CeleryCropBlock;
import com.shakkas.diversitydelight.block.custom.ColeCropBlock;
import com.shakkas.diversitydelight.block.custom.LowerDoubleFruitingCropBlock;
import com.shakkas.diversitydelight.block.custom.LowerDoubleSupportCropBlock;
import com.shakkas.diversitydelight.block.custom.UpperDoubleFruitingCropBlock;
import com.shakkas.diversitydelight.block.custom.WormBinBlock;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.common.block.FeastBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "diversitydelight", exFileHelper);
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"diversitydelight", (String)("block/" + path));
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.customStageBlock((Block)ModBlocks.BROCCOLI_CROP.get(), this.mcLoc("cross"), "cross", ColeCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 3, 4, 4, 5), new Property[0]);
        this.customStageBlock((Block)ModBlocks.CAULIFLOWER_CROP.get(), this.mcLoc("cross"), "cross", ColeCropBlock.AGE, Arrays.asList(0, 1, 2, 2, 3, 3, 4, 5), new Property[0]);
        this.customStageBlock((Block)ModBlocks.CELERY_CROP.get(), this.mcLoc("crop"), "crop", CeleryCropBlock.AGE, Arrays.asList(0, 0, 1, 1, 2, 2, 2, 3), new Property[0]);
        this.customStageBlock((Block)ModBlocks.LOWER_BELL_PEPPER_CROP.get(), this.mcLoc("crop"), "crop", LowerDoubleSupportCropBlock.AGE, Arrays.asList(0, 1, 1, 2, 2, 3, 3, 4), new Property[0]);
        this.customStageBlock((Block)ModBlocks.UPPER_BELL_PEPPER_CROP.get(), this.mcLoc("crop"), "crop", UpperDoubleFruitingCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 4, 5, 5, 6), new Property[0]);
        this.customStageBlock((Block)ModBlocks.LOWER_CHILI_CROP.get(), this.mcLoc("crop"), "crop", LowerDoubleSupportCropBlock.AGE, Arrays.asList(0, 1, 1, 2, 2, 3, 3, 4), new Property[0]);
        this.customStageBlock((Block)ModBlocks.UPPER_CHILI_CROP.get(), this.mcLoc("crop"), "crop", UpperDoubleFruitingCropBlock.AGE, Arrays.asList(0, 1, 1, 2, 2, 3, 3, 4), new Property[0]);
        this.customStageBlock((Block)ModBlocks.LOWER_GREEN_BEAN_CROP.get(), this.mcLoc("crop"), "crop", LowerDoubleFruitingCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 3, 4, 4, 5), new Property[0]);
        this.customStageBlock((Block)ModBlocks.UPPER_GREEN_BEAN_CROP.get(), this.mcLoc("crop"), "crop", UpperDoubleFruitingCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 3, 4, 4, 5), new Property[0]);
        this.customStageBlock((Block)ModBlocks.LOWER_PEA_CROP.get(), this.mcLoc("cross"), "cross", LowerDoubleFruitingCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 3, 4, 4, 5), new Property[0]);
        this.customStageBlock((Block)ModBlocks.UPPER_PEA_CROP.get(), this.mcLoc("cross"), "cross", UpperDoubleFruitingCropBlock.AGE, Arrays.asList(0, 1, 2, 3, 3, 4, 4, 5), new Property[0]);
        this.wormBinBlock((WormBinBlock)((Object)ModBlocks.WORM_BIN_BLOCK.get()));
        this.crateBlock((Block)ModBlocks.BELL_PEPPER_CRATE.get(), "bell_pepper");
        this.crateBlock((Block)ModBlocks.BROCCOLI_CRATE.get(), "broccoli");
        this.crateBlock((Block)ModBlocks.CAULIFLOWER_CRATE.get(), "cauliflower");
        this.crateBlock((Block)ModBlocks.CELERY_CRATE.get(), "celery");
        this.crateBlock((Block)ModBlocks.CHILI_CRATE.get(), "chili");
        this.crateBlock((Block)ModBlocks.GREEN_BEAN_CRATE.get(), "green_bean");
        this.crateBlock((Block)ModBlocks.PEA_CRATE.get(), "pea");
        this.feastBlock((FeastBlock)ModBlocks.CHICKEN_POT_PIE_BLOCK.get());
        this.feastBlock((FeastBlock)ModBlocks.VEGETABLE_STICKS_BLOCK.get());
        this.wildCropBlock((Block)ModBlocks.WILD_BELL_PEPPER.get());
        this.wildCropBlock((Block)ModBlocks.WILD_BROCCOLI.get());
        this.wildCropBlock((Block)ModBlocks.WILD_CAULIFLOWER.get());
        this.wildCropBlock((Block)ModBlocks.WILD_CELERY.get());
        this.wildCropBlock((Block)ModBlocks.WILD_CHILI.get());
        this.wildCropBlock((Block)ModBlocks.WILD_GREEN_BEAN.get());
        this.wildCropBlock((Block)ModBlocks.WILD_PEA.get());
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlockWithItem(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_crate_side"), this.resourceBlock("crate_bottom"), this.resourceBlock(cropName + "_crate_top")));
    }

    public void wormBinBlock(WormBinBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            int level = (Integer)state.getValue((Property)WormBinBlock.LEVEL);
            String contentSuffix = "_contents" + level;
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile(this.existingModel(this.blockName((Block)block) + contentSuffix)).rotationY(((int)((Direction)state.getValue((Property)WormBinBlock.FACING)).toYRot() + 180) % 360);
            return builder.build();
        });
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.getValue((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(stageName, parent, textureKey, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void wildCropBlock(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.getValue((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.getPossibleValues().toArray().length - 2);
            }
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName((Block)block) + (String)suffix)).rotationY(((int)((Direction)state.getValue((Property)FeastBlock.FACING)).toYRot() + 180) % 360).build();
        });
    }
}

