/*
 * Decompiled with CFR 0.152.
 */
package com.shakkas.diversitydelight.item;

import com.shakkas.diversitydelight.component.CondimentProperties;
import com.shakkas.diversitydelight.component.ModComponents;
import com.shakkas.diversitydelight.utils.TagUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class CondimentItem
extends Item {
    protected static final String CATEGORY = "condiment";

    public CondimentItem(Item.Properties properties) {
        super(properties);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getCondimentName() {
        return BuiltInRegistries.ITEM.getKey((Object)this).getPath();
    }

    public boolean canApplyCondiment(ItemStack stack, String category, Player player) {
        return !TagUtils.hasString(stack, category) && stack.getItem().getFoodProperties(stack, (LivingEntity)player) != null;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        String category;
        ItemStack condimentStack = player.getItemInHand(hand);
        EquipmentSlot useSlot = LivingEntity.getSlotForHand((InteractionHand)hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otherHeldItem = player.getItemInHand(otherHand);
        if (this.canApplyCondiment(otherHeldItem, category = CATEGORY, player)) {
            condimentStack.hurtAndBreak(1, (LivingEntity)player, useSlot);
            this.applyCondiment(condimentStack, otherHeldItem, category, player);
            return InteractionResultHolder.sidedSuccess((Object)condimentStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)condimentStack);
    }

    public void applyCondiment(ItemStack condimentStack, ItemStack stack, String category, Player player) {
        ItemStack targetItem = stack.copy();
        this.modifyFood(condimentStack, targetItem, category, this.getCondimentName());
        stack.shrink(1);
        targetItem.setCount(1);
        player.addItem(targetItem);
        player.playNotifySound(SoundEvents.HONEY_BLOCK_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void modifyFood(ItemStack condimentStack, ItemStack stack, String category, String condimentType) {
        CompoundTag root = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        root.putString(category, condimentType);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
        stack.set(DataComponents.FOOD, (Object)this.modifiedFoodProperties(condimentStack, stack, condimentType));
    }

    public FoodProperties modifiedFoodProperties(ItemStack condimentStack, ItemStack stack, String condimentType) {
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        CondimentProperties modifier = (CondimentProperties)condimentStack.getOrDefault(ModComponents.CONDIMENT_PROPERTIES, (Object)CondimentProperties.EMPTY);
        int originalNutrition = base.nutrition();
        float originalSaturation = base.saturation();
        List effects = base.effects();
        int extraNutrition = modifier.nutritionBonus();
        float extraSaturation = modifier.saturationBonus();
        boolean canAlwaysEat = modifier.alwaysEdible();
        boolean fast = modifier.fast();
        List<FoodProperties.PossibleEffect> extraEffects = modifier.extraEffects();
        List combinedEffects = Stream.concat(effects.stream(), extraEffects.stream()).toList();
        FoodProperties.Builder modifiedBase = new FoodProperties.Builder().nutrition(originalNutrition + extraNutrition).saturationModifier(originalSaturation + extraSaturation);
        if (canAlwaysEat) {
            modifiedBase.alwaysEdible();
        }
        if (fast) {
            modifiedBase.fast();
        }
        for (FoodProperties.PossibleEffect e : combinedEffects) {
            modifiedBase.effect(e.effect(), 1.0f);
        }
        return modifiedBase.build();
    }
}

