/*
 * Decompiled with CFR 0.152.
 */
package com.shakkas.diversitydelight.utils;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class TagUtils {
    public static boolean hasList(ItemStack stack, String category) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return false;
        }
        CompoundTag root = data.copyTag();
        return root.contains(category, 9);
    }

    public static boolean listHasString(ItemStack stack, String category, String item) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return false;
        }
        ListTag targetList = TagUtils.getList(stack, category);
        if (targetList == null) {
            return false;
        }
        for (int i = 0; i < targetList.size(); ++i) {
            if (!targetList.getString(i).equals(item)) continue;
            return true;
        }
        return false;
    }

    public static ListTag getList(ItemStack stack, String category) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return null;
        }
        CompoundTag root = data.copyTag();
        if (!root.contains(category, 9)) {
            return null;
        }
        return root.getList(category, 8);
    }

    public static boolean hasString(ItemStack stack, String category) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (data.isEmpty()) {
            return false;
        }
        CompoundTag root = data.copyTag();
        return !root.getString(category).isEmpty();
    }

    public static String getString(ItemStack stack, String category) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag root = data.copyTag();
        if (!TagUtils.hasString(stack, category)) {
            return "";
        }
        return root.getString(category);
    }
}

