/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.hotkettles.item;

import com.matthewperiut.hotkettles.block.KettleBlock;
import com.matthewperiut.hotkettles.block.MugBlock;
import com.matthewperiut.hotkettles.blockentity.KettleBlockEntity;
import com.matthewperiut.hotkettles.item.HotKettleItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MugItem
extends BlockItem {
    boolean hot = false;

    public MugItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public MugItem(Block block, Item.Properties settings, boolean hot) {
        super(block, settings);
        this.hot = hot;
    }

    public InteractionResult place(BlockPlaceContext context) {
        InteractionResult result = super.place(context);
        if (result == InteractionResult.SUCCESS && this.hot) {
            context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)context.getLevel().getBlockState(context.getClickedPos()).setValue(MugBlock.HOT, (Comparable)Boolean.valueOf(true)));
        }
        return result;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        super.finishUsingItem(stack, world, user);
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)user;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayerEntity, stack);
            serverPlayerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!world.isClientSide) {
            if (this.getDescriptionId().contains("lava")) {
                user.lavaHurt();
            }
            if (this.getDescriptionId().contains("milk")) {
                user.removeAllEffects();
            }
        }
        if (stack.isEmpty()) {
            return new ItemStack((ItemLike)HotKettleItems.EMPTY_MUG.get());
        }
        if (user instanceof Player && !((Player)user).getAbilities().instabuild) {
            ItemStack itemStack = new ItemStack((ItemLike)HotKettleItems.EMPTY_MUG.get());
            Player playerEntity = (Player)user;
            if (!playerEntity.getInventory().add(itemStack)) {
                playerEntity.drop(itemStack, false);
            }
        }
        return stack;
    }

    public InteractionResult useOn(UseOnContext context) {
        KettleBlockEntity kettle;
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof KettleBlockEntity && !(kettle = (KettleBlockEntity)blockEntity).isFull()) {
            Item i = context.getPlayer().getItemInHand(context.getHand()).getItem();
            if (i.equals(HotKettleItems.HOT_CIDER.get())) {
                i = (Item)HotKettleItems.APPLE_CIDER.get();
            } else if (i.equals(HotKettleItems.STEAMED_MILK.get())) {
                i = (Item)HotKettleItems.CUP_OF_MILK.get();
            } else if (i.equals(HotKettleItems.HOT_COCOA.get())) {
                i = (Item)HotKettleItems.BITTER_WATER.get();
            } else if (i.equals(HotKettleItems.HOT_WATER.get())) {
                i = (Item)HotKettleItems.CUP_OF_WATER.get();
            }
            boolean success = false;
            BlockState kettleBlockState = context.getLevel().getBlockState(context.getClickedPos());
            if ((Integer)kettleBlockState.getValue((Property)KettleBlock.KETTLE_TYPE) == 0) {
                if (i.equals(HotKettleItems.POISON.get())) {
                    context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)kettleBlockState.setValue((Property)KettleBlock.KETTLE_TYPE, (Comparable)Integer.valueOf(1)));
                    kettle = (KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
                    kettle.setLiquidLevel(1);
                    kettle.setLiquidHorizontalOffset(2);
                    success = true;
                } else if (i.equals(HotKettleItems.CUP_OF_WATER.get())) {
                    context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)kettleBlockState.setValue((Property)KettleBlock.KETTLE_TYPE, (Comparable)Integer.valueOf(2)));
                    kettle = (KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
                    kettle.setLiquidLevel(1);
                    kettle.setLiquidHorizontalOffset(4);
                    success = true;
                } else if (i.equals(HotKettleItems.CUP_OF_MILK.get())) {
                    context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)kettleBlockState.setValue((Property)KettleBlock.KETTLE_TYPE, (Comparable)Integer.valueOf(3)));
                    kettle = (KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
                    kettle.setLiquidLevel(1);
                    kettle.setLiquidHorizontalOffset(6);
                    success = true;
                } else if (i.equals(HotKettleItems.BITTER_WATER.get())) {
                    context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)kettleBlockState.setValue((Property)KettleBlock.KETTLE_TYPE, (Comparable)Integer.valueOf(4)));
                    kettle = (KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
                    kettle.setLiquidLevel(1);
                    kettle.setLiquidHorizontalOffset(8);
                    success = true;
                } else if (i.equals(HotKettleItems.APPLE_CIDER.get())) {
                    context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)kettleBlockState.setValue((Property)KettleBlock.KETTLE_TYPE, (Comparable)Integer.valueOf(5)));
                    kettle = (KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
                    kettle.setLiquidLevel(1);
                    kettle.setLiquidHorizontalOffset(10);
                    success = true;
                } else if (i.equals(HotKettleItems.CUP_OF_LAVA.get())) {
                    context.getLevel().setBlockAndUpdate(context.getClickedPos(), (BlockState)kettleBlockState.setValue((Property)KettleBlock.KETTLE_TYPE, (Comparable)Integer.valueOf(6)));
                    kettle = (KettleBlockEntity)context.getLevel().getBlockEntity(context.getClickedPos());
                    kettle.setLiquidLevel(1);
                    kettle.setLiquidHorizontalOffset(12);
                    success = true;
                }
            }
            if (i.equals(HotKettleItems.POISON.get())) {
                if ((Integer)kettleBlockState.getValue((Property)KettleBlock.KETTLE_TYPE) == 1) {
                    kettle.addLiquid();
                    success = true;
                }
            } else if (i.equals(HotKettleItems.CUP_OF_WATER.get())) {
                if ((Integer)kettleBlockState.getValue((Property)KettleBlock.KETTLE_TYPE) == 2) {
                    kettle.addLiquid();
                    success = true;
                }
            } else if (i.equals(HotKettleItems.CUP_OF_MILK.get())) {
                if ((Integer)kettleBlockState.getValue((Property)KettleBlock.KETTLE_TYPE) == 3) {
                    kettle.addLiquid();
                    success = true;
                }
            } else if (i.equals(HotKettleItems.BITTER_WATER.get())) {
                if ((Integer)kettleBlockState.getValue((Property)KettleBlock.KETTLE_TYPE) == 4) {
                    kettle.addLiquid();
                    success = true;
                }
            } else if (i.equals(HotKettleItems.APPLE_CIDER.get())) {
                if ((Integer)kettleBlockState.getValue((Property)KettleBlock.KETTLE_TYPE) == 5) {
                    kettle.addLiquid();
                    success = true;
                }
            } else if (i.equals(HotKettleItems.CUP_OF_LAVA.get()) && (Integer)kettleBlockState.getValue((Property)KettleBlock.KETTLE_TYPE) == 6) {
                kettle.addLiquid();
                success = true;
            }
            if (success) {
                int count = context.getPlayer().getItemInHand(context.getHand()).getCount();
                if (count == 1) {
                    context.getPlayer().setItemInHand(context.getHand(), new ItemStack((ItemLike)HotKettleItems.EMPTY_MUG.get()));
                } else {
                    context.getPlayer().getItemInHand(context.getHand()).setCount(count - 1);
                    context.getPlayer().addItem(new ItemStack((ItemLike)HotKettleItems.EMPTY_MUG.get()));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }
}

