/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import sweetmagic.api.SweetMagicAPI;
import sweetmagic.api.magiaflux.MFItemList;
import sweetmagic.api.magiaflux.MagiaFluxInfo;
import sweetmagic.handler.ComposterHandler;
import sweetmagic.handler.PacketHandler;
import sweetmagic.handler.RegisterHandler;
import sweetmagic.init.AdvancedInit;
import sweetmagic.init.BlockInit;
import sweetmagic.init.DimentionInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.LootInit;
import sweetmagic.init.tile.menu.SMBookMenu;
import sweetmagic.plugin.terrablender.SMBiomeRegion;

@Mod(value="sweetmagic")
public class SweetMagicCore {
    public static boolean terrablenderLoaded = false;
    public static boolean mousetweaksLoaded = false;
    public static final String MODID = "sweetmagic";

    public SweetMagicCore() {
        IEventBus event = FMLJavaModLoadingContext.get().getModEventBus();
        terrablenderLoaded = ModList.get().isLoaded("terrablender");
        mousetweaksLoaded = ModList.get().isLoaded("mousetweaks");
        event.addListener(this::commonSetup);
        event.addListener(this::enqueueEvent);
        RegisterHandler handler = RegisterHandler.INSTANCE;
        handler.registerInit(event);
        handler.registerConfig();
        handler.registerEvent(event);
        event.register((Object)this);
        MFItemList.INSTANCE.addPluginList();
        handler.registerGrassDrop(event);
        LootInit.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            PacketHandler.register();
            ComposterHandler.registerCompostables();
            BlockInit.registerPots();
        });
        if (terrablenderLoaded) {
            SMBiomeRegion.register();
        }
        DimentionInit.init();
        AdvancedInit.init();
        MagiaFluxInfo info = new MagiaFluxInfo();
        SweetMagicAPI.getMFPluginList().forEach(mf -> mf.setMF(info));
    }

    private void enqueueEvent(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"craftingtweaks", (String)"RegisterProvider", () -> {
            CompoundTag tags = new CompoundTag();
            tags.m_128359_("ContainerClass", SMBookMenu.class.getName());
            tags.m_128359_("AlignToGrid", "left");
            return tags;
        });
    }

    public static ResourceLocation getSRC(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static <T> DeferredRegister<T> getDef(IForgeRegistry<T> reg) {
        return DeferredRegister.create(reg, (String)MODID);
    }

    @Mod.EventBusSubscriber(modid="sweetmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterSpawn {
        @SubscribeEvent
        public static void registerSpawn(SpawnPlacementRegisterEvent event) {
            EntityInit.registerSpawn(event);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            RegisterHandler.onRegisterEvent(event);
        }
    }

    @Mod.EventBusSubscriber(modid="sweetmagic", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerKeybindings(RegisterKeyMappingsEvent event) {
            RegisterHandler.registerKeybind(event);
        }
    }
}

