/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.api.iblock;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import sweetmagic.init.BlockInit;
import sweetmagic.init.block.sm.PottingSoil;

public interface ISMCrop {
    public static final IntegerProperty AGE1 = BlockStateProperties.f_61405_;
    public static final IntegerProperty AGE2 = BlockStateProperties.f_61406_;
    public static final IntegerProperty AGE3 = BlockStateProperties.f_61407_;
    public static final IntegerProperty AGE4 = BlockStateProperties.f_222999_;
    public static final IntegerProperty AGE5 = BlockStateProperties.f_61408_;
    public static final IntegerProperty AGE7 = BlockStateProperties.f_61409_;

    public int getMaxBlockState();

    public IntegerProperty getSMMaxAge();

    public void setGlowChance(int var1);

    public int getGlowChange();

    public ItemLike getSeed();

    public ItemLike getCrop();

    public BlockState getDefault();

    default public int RCSetState() {
        return 0;
    }

    default public int getDropValue(RandomSource rand, int fortune) {
        return 1;
    }

    default public ItemStack getDropStack(RandomSource rand) {
        return new ItemStack(this.getCrop(), this.getDropValue(rand, 0));
    }

    default public List<ItemStack> rightClickStack(Level world, BlockState state, BlockPos pos) {
        List<ItemStack> stackList = Arrays.asList(this.getDropStack(world.m_213780_()));
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        return stackList;
    }

    default public ItemEntity getDropItem(Level world, Player player, ItemStack hand, ItemLike item, int amount) {
        return new ItemEntity(world, player.f_19854_, player.f_19855_, player.f_19856_, new ItemStack(item, amount));
    }

    default public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
    }

    default public boolean breakBlock(Level world, BlockPos pos) {
        return world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    default public void playCropSound(Level world, RandomSource rand, BlockPos pos, float vol) {
        world.m_5594_(null, pos, SoundEvents.f_11991_, SoundSource.BLOCKS, vol, 0.8f + rand.m_188501_() * 0.4f);
    }

    default public void playCropSound(Level world, RandomSource rand, BlockPos pos) {
        this.playCropSound(world, rand, pos, 0.5f);
    }

    default public int getFoutuneValue(Player player) {
        int value = 0;
        if (player.m_21023_(MobEffects.f_19621_)) {
            value += player.m_21124_(MobEffects.f_19621_).m_19564_();
        }
        return value;
    }

    default public Item getDropItem() {
        return null;
    }

    default public Block getBlock(LevelAccessor world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_();
    }

    default public int getNowState(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getSMMaxAge());
    }

    default public boolean isMaxAge(BlockState state) {
        return this.getNowState(state) >= this.getMaxBlockState();
    }

    default public boolean isGlowChange(RandomSource rand) {
        return rand.m_188503_(this.getGlowChange()) == 0;
    }

    default public void growCrops(Level world, BlockPos pos, BlockState state) {
        int age = Math.min(this.getNowState(state) + this.getBonemealAgeIncrease(world), this.getMaxBlockState());
        world.m_7731_(pos, this.getStateForAge(age), 2);
    }

    default public int getBonemealAgeIncrease(Level world) {
        return Mth.m_216271_((RandomSource)world.m_213780_(), (int)0, (int)Math.min(2, this.getMaxBlockState() - 2));
    }

    default public BlockState getStateForAge(int addAge) {
        return (BlockState)this.getDefault().m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(addAge));
    }

    default public List<ItemStack> getDropList(BlockState state, LootParams.Builder build) {
        ArrayList stackList = Lists.newArrayList();
        RandomSource rand = build.m_287258_().m_213780_();
        ItemLike seed = this.getSeed();
        if (this.isMaxAge(state)) {
            stackList.add(new ItemStack(this.getCrop(), rand.m_188503_(this.getMaxBlockState()) + 1));
            if (seed != this.getCrop() && seed != null) {
                stackList.add(new ItemStack(seed, rand.m_188503_(2)));
            }
        }
        if (seed != null) {
            stackList.add(new ItemStack(this.getSeed()));
        }
        return stackList;
    }

    default public boolean isOnlyFarm() {
        return false;
    }

    default public boolean checkPlace(BlockState state, BlockGetter get, BlockPos pos) {
        return this.isOnlyFarm() ? state.m_60713_(Blocks.f_50093_) || state.m_60734_() instanceof PottingSoil || state.m_60713_(BlockInit.aether_planter) : state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50093_);
    }
}

