/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.event.SMLivingTickEvent;
import sweetmagic.init.CapabilityInit;
import sweetmagic.init.EnchantInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.capability.icap.ICookingStatus;
import sweetmagic.init.entity.monster.DwarfZombie;

public class LivingDethEvent {
    private static final Map<UUID, Inventory> playerKeepsMap = new HashMap<UUID, Inventory>();

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (entity.m_21023_(PotionInit.resurrection)) {
            Level world = entity.m_9236_();
            entity.m_21153_(entity.m_21233_() / 2.0f);
            entity.m_21195_(PotionInit.resurrection);
            world.m_5594_(null, entity.m_20183_(), SoundEvents.f_12513_, SoundSource.VOICE, 0.5f, 1.0f);
            if (world instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)world;
                RandomSource rand = world.m_213780_();
                for (int i = 0; i < 16; ++i) {
                    double xS = rand.m_188583_() * 0.015;
                    double yS = rand.m_188583_() * 0.02;
                    double zS = rand.m_188583_() * 0.015;
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20208_(1.0), entity.m_20187_() + 0.25, entity.m_20262_(1.0), 0, xS, yS, zS, 1.0);
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123815_, entity.m_20208_(1.0), entity.m_20187_() + 0.25, entity.m_20262_(1.0), 0, xS, yS, zS, 1.0);
                }
            }
            event.setCanceled(true);
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Inventory pInv = player.m_150109_();
            Inventory keepInv = new Inventory(player);
            int count = -1;
            for (ItemStack stack : pInv.f_35974_) {
                ++count;
                if (stack.m_41619_() || EnchantmentHelper.m_44843_((Enchantment)EnchantInit.aethercharm, (ItemStack)stack) < 1) continue;
                keepInv.f_35974_.set(count, (Object)stack.m_41777_());
                stack.m_41774_(stack.m_41613_());
            }
            count = -1;
            for (ItemStack stack : pInv.f_35975_) {
                ++count;
                if (stack.m_41619_() || EnchantmentHelper.m_44843_((Enchantment)EnchantInit.aethercharm, (ItemStack)stack) < 1) continue;
                keepInv.f_35975_.set(count, (Object)stack.m_41777_());
                stack.m_41774_(stack.m_41613_());
            }
            count = -1;
            for (ItemStack stack : pInv.f_35976_) {
                ++count;
                if (stack.m_41619_() || EnchantmentHelper.m_44843_((Enchantment)EnchantInit.aethercharm, (ItemStack)stack) < 1) continue;
                keepInv.f_35976_.set(count, (Object)stack.m_41777_());
                stack.m_41774_(stack.m_41613_());
            }
            playerKeepsMap.put(player.m_20148_(), keepInv);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ItemStack pStack;
        NonNullList pList;
        ItemStack stack;
        int i;
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        Inventory keepInv = playerKeepsMap.remove(player.m_20148_());
        if (keepInv == null) {
            return;
        }
        Inventory pInv = player.m_150109_();
        NonNullList items = keepInv.f_35974_;
        NonNullList armor = keepInv.f_35975_;
        NonNullList offhand = keepInv.f_35976_;
        for (i = 0; i < items.size(); ++i) {
            stack = (ItemStack)items.get(i);
            if (stack.m_41619_()) continue;
            pList = pInv.f_35974_;
            pStack = (ItemStack)pList.get(i);
            if (!pStack.m_41619_()) {
                Level world = player.m_9236_();
                if (world.m_5776_()) {
                    return;
                }
                BlockPos pos = player.m_20183_();
                world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack.m_41777_()));
                continue;
            }
            pList.set(i, (Object)stack);
        }
        for (i = 0; i < armor.size(); ++i) {
            stack = (ItemStack)armor.get(i);
            if (stack.m_41619_() || !(pStack = (ItemStack)(pList = pInv.f_35975_).get(i)).m_41619_()) continue;
            pList.set(i, (Object)stack);
        }
        for (i = 0; i < offhand.size(); ++i) {
            stack = (ItemStack)offhand.get(i);
            if (stack.m_41619_() || !(pStack = (ItemStack)(pList = pInv.f_35976_).get(i)).m_41619_()) continue;
            pList.set(i, (Object)stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player == null || !ICookingStatus.hasValue((LivingEntity)player)) {
            return;
        }
        ICookingStatus.getState((LivingEntity)player).setHealth(player.m_21223_());
        Inventory keepInv = playerKeepsMap.remove(player.m_20148_());
        if (keepInv == null) {
            return;
        }
        keepInv.m_36071_();
    }

    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        original.reviveCaps();
        original.getCapability(CapabilityInit.COOK).ifPresent(old -> event.getEntity().getCapability(CapabilityInit.COOK).ifPresent(c -> c.deserializeNBT((Tag)((CompoundTag)old.serializeNBT()))));
    }

    @SubscribeEvent
    public static void loginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ICookingStatus.sendPKT(player);
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_6844_(EquipmentSlot.FEET);
        CompoundTag tags = player.getPersistentData();
        if (SMLivingTickEvent.isHarness(stack)) {
            player.m_150110_().f_35936_ = true;
            if (!player.m_20096_()) {
                player.m_150110_().f_35935_ = true;
            }
            player.m_6885_();
            tags.m_128379_("isHarness", true);
        }
    }

    @SubscribeEvent
    public static void onEvent(LivingDropsEvent event) {
        Collection itemList = event.getDrops();
        LivingEntity entity = event.getEntity();
        Level world = entity.m_9236_();
        RandomSource rand = world.m_213780_();
        double x = entity.f_19854_;
        double y = entity.f_19855_;
        double z = entity.f_19856_;
        if (entity instanceof Witch && rand.m_188499_()) {
            itemList.add(LivingDethEvent.getItem(world, x, y, z, ItemInit.mysterious_page, rand.m_188503_(2) + 1));
        } else if ((entity instanceof Zombie || entity instanceof DwarfZombie) && rand.m_188501_() <= 0.15f) {
            itemList.add(LivingDethEvent.getItem(world, x, y, z, ItemInit.egg_bag, rand.m_188503_(2) + 1));
        } else if (entity instanceof Creeper) {
            itemList.add(LivingDethEvent.getItem(world, x, y, z, ItemInit.magic_meal, rand.m_188503_(2) + 1));
        } else if (entity instanceof Chicken) {
            itemList.add(LivingDethEvent.getItem(world, x, y, z, Items.f_42402_, rand.m_188503_(3) + 1));
        } else if (entity instanceof ISMMob) {
            itemList.removeIf(s -> s.m_32055_().m_41763_());
        }
        if (entity.m_21023_(PotionInit.darkness_fog)) {
            itemList.clear();
            if (entity.m_21023_(PotionInit.leader_flag) && entity.m_21124_(PotionInit.leader_flag).m_19564_() + 1 >= 2) {
                itemList.add(LivingDethEvent.getItem(world, x, y, z, ItemInit.evil_arrow, 3));
            }
        }
    }

    public static ItemEntity getItem(Level world, double x, double y, double z, Item item, int amount) {
        return new ItemEntity(world, x, y, z, new ItemStack((ItemLike)item, amount));
    }

    @SubscribeEvent
    public static void dropEvent(LivingDropsEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().m_7640_();
        if (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).m_21023_(PotionInit.drop_increase)) {
            return;
        }
        RandomSource rand = entity.m_9236_().m_213780_();
        Collection entityList = event.getDrops();
        int level = living.m_21124_(PotionInit.drop_increase).m_19564_() + 1;
        for (ItemEntity item : entityList) {
            for (int i = 0; i < level; ++i) {
                ItemStack stack;
                if (!rand.m_188499_() || (stack = item.m_32055_()).m_41613_() >= 64) continue;
                stack.m_41764_(stack.m_41613_() + 1);
            }
        }
    }

    @SubscribeEvent
    public static void dropExpEvent(LivingExperienceDropEvent event) {
        if (event.getEntity().m_21023_(PotionInit.darkness_fog)) {
            event.setCanceled(true);
        }
    }
}

